/*
 * Decompiled with CFR 0.152.
 */
package com.noleme.flow.connect.commons.transformer.filesystem;

import com.noleme.flow.actor.transformer.TransformationException;
import com.noleme.flow.actor.transformer.Transformer;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateDirectory<I>
implements Transformer<I, I> {
    private final Function<I, Path> pathCreator;
    private static final Logger logger = LoggerFactory.getLogger(CreateDirectory.class);

    public CreateDirectory(Path path) {
        this.pathCreator = any -> path;
    }

    public CreateDirectory(String path) {
        this(Path.of(path, new String[0]));
    }

    public CreateDirectory(Function<I, Path> pathCreator) {
        this.pathCreator = pathCreator;
    }

    public I transform(I input) throws TransformationException {
        try {
            Path path = this.pathCreator.apply(input);
            if (!Files.exists(path, new LinkOption[0])) {
                logger.info("Initializing stream from filesystem at {}", (Object)path);
                Files.createDirectory(path, new FileAttribute[0]);
            } else if (Files.isDirectory(path, new LinkOption[0])) {
                logger.info("Directory already exists at {}", (Object)path);
            } else {
                logger.info("A file already exists at {}", (Object)path);
            }
            return input;
        }
        catch (IOException e) {
            throw new TransformationException(e.getMessage(), (Throwable)e);
        }
    }
}

