/*
 * Decompiled with CFR 0.152.
 */
package com.noleme.flow.connect.commons.transformer.filesystem;

import com.noleme.flow.actor.transformer.Transformer;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryScanner
implements Transformer<String, Set<String>> {
    private final Predicate<Path> filter;
    private static final Logger logger = LoggerFactory.getLogger(DirectoryScanner.class);

    public DirectoryScanner() {
        this(path -> true);
    }

    public DirectoryScanner(Predicate<Path> filter) {
        this.filter = filter;
    }

    public Set<String> transform(String directory) throws IOException {
        try (Stream<Path> files = Files.list(Paths.get(directory, new String[0]));){
            Set<String> paths = files.filter(f -> !Files.isDirectory(f, new LinkOption[0])).filter(this.filter).map(Path::toString).collect(Collectors.toSet());
            logger.info("Scanning files in directory {} returned {} file(s)", (Object)directory, (Object)paths.size());
            Set<String> set = paths;
            return set;
        }
    }
}

