/*
 * Decompiled with CFR 0.152.
 */
package com.noleme.flow.connect.commons.transformer.filesystem;

import com.noleme.commons.file.Files;
import com.noleme.commons.file.Resources;
import com.noleme.flow.actor.transformer.TransformationException;
import com.noleme.flow.actor.transformer.Transformer;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlexibleStreamer
implements Transformer<String, InputStream> {
    private static final Logger logger = LoggerFactory.getLogger(FlexibleStreamer.class);

    public InputStream transform(String path) throws TransformationException, IOException {
        if (Files.fileExists((String)path)) {
            logger.info("Initializing stream from filesystem at {}", (Object)path);
            return Files.streamFrom((String)path);
        }
        if (Resources.exists((String)path)) {
            logger.info("Initializing stream from resources at {}", (Object)path);
            return Resources.streamFrom((String)path);
        }
        throw new TransformationException("No file nor resource could be found at path " + path);
    }
}

