/*
 * Decompiled with CFR 0.152.
 */
package com.noleme.flow.connect.commons.transformer.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.noleme.flow.actor.transformer.TransformationException;
import com.noleme.flow.actor.transformer.Transformer;
import com.noleme.json.Json;
import com.noleme.json.JsonException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseJsonObject
implements Transformer<InputStream, ObjectNode> {
    private static final Logger logger = LoggerFactory.getLogger(ParseJsonObject.class);

    public ObjectNode transform(InputStream input) throws TransformationException {
        try {
            logger.info("Transforming input stream into a JSON object.");
            JsonNode json = Json.parse((InputStream)input);
            if (!json.isObject()) {
                throw new TransformationException("The provided input could be parsed as JSON but doesn't seem to represent a JSON object.");
            }
            return (ObjectNode)json;
        }
        catch (JsonException e) {
            throw new TransformationException("An error occurred while attempting to parse input as a JSON object.", (Throwable)e);
        }
    }
}

