/*
 * Decompiled with CFR 0.152.
 */
package com.noleme.flow.connect.commons.transformer.yaml;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.noleme.flow.actor.transformer.TransformationException;
import com.noleme.flow.actor.transformer.Transformer;
import com.noleme.json.JsonException;
import com.noleme.json.Yaml;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseYamlArray
implements Transformer<InputStream, ArrayNode> {
    private static final Logger logger = LoggerFactory.getLogger(ParseYamlArray.class);

    public ArrayNode transform(InputStream input) throws TransformationException {
        try {
            logger.info("Transforming input stream into a YAML array.");
            JsonNode yaml = Yaml.parse((InputStream)input);
            if (!yaml.isArray()) {
                throw new TransformationException("The provided input could be parsed as YAML but doesn't seem to represent a YAML array.");
            }
            return (ArrayNode)yaml;
        }
        catch (JsonException e) {
            throw new TransformationException("An error occurred while attempting to parse input as a YAML array.", (Throwable)e);
        }
    }
}

