/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import com.nvidia.spark.rapids.DateUtils;
import com.nvidia.spark.rapids.GpuOverrides$;
import com.nvidia.spark.rapids.RapidsConf$;
import com.nvidia.spark.rapids.RapidsMeta;
import java.time.Instant;
import java.time.LocalDate;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.rapids.GpuToTimestamp$;
import org.apache.spark.sql.rapids.LegacyTimeParserPolicy$;
import org.apache.spark.sql.rapids.TimeParserPolicy;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.generic.TraversableForwarder;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

public final class DateUtils$ {
    public static final DateUtils$ MODULE$;
    private final Set<Object> unsupportedCharacter;
    private final Set<String> unsupportedWord;
    private final Set<String> unsupportedWordParseFromString;
    private final Map<String, String> conversionMap;
    private final int ONE_SECOND_MICROSECONDS;
    private final long ONE_DAY_SECONDS;
    private final long ONE_DAY_MICROSECONDS;
    private final String EPOCH;
    private final String NOW;
    private final String TODAY;
    private final String YESTERDAY;
    private final String TOMORROW;

    static {
        new DateUtils$();
    }

    public Set<Object> unsupportedCharacter() {
        return this.unsupportedCharacter;
    }

    public Set<String> unsupportedWord() {
        return this.unsupportedWord;
    }

    public Set<String> unsupportedWordParseFromString() {
        return this.unsupportedWordParseFromString;
    }

    public Map<String, String> conversionMap() {
        return this.conversionMap;
    }

    public int ONE_SECOND_MICROSECONDS() {
        return this.ONE_SECOND_MICROSECONDS;
    }

    public long ONE_DAY_SECONDS() {
        return this.ONE_DAY_SECONDS;
    }

    public long ONE_DAY_MICROSECONDS() {
        return this.ONE_DAY_MICROSECONDS;
    }

    public String EPOCH() {
        return this.EPOCH;
    }

    public String NOW() {
        return this.NOW;
    }

    public String TODAY() {
        return this.TODAY;
    }

    public String YESTERDAY() {
        return this.YESTERDAY;
    }

    public String TOMORROW() {
        return this.TOMORROW;
    }

    public Map<String, Object> specialDatesDays() {
        int today = this.currentDate();
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.EPOCH()), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.NOW()), (Object)BoxesRunTime.boxToInteger((int)today)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.TODAY()), (Object)BoxesRunTime.boxToInteger((int)today)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.YESTERDAY()), (Object)BoxesRunTime.boxToInteger((int)(today - 1))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.TOMORROW()), (Object)BoxesRunTime.boxToInteger((int)(today + 1)))}));
    }

    public Map<String, Object> specialDatesSeconds() {
        int today = this.currentDate();
        long now = DateTimeUtils$.MODULE$.instantToMicros(Instant.now());
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.EPOCH()), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.NOW()), (Object)BoxesRunTime.boxToLong((long)(now / 1000000L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.TODAY()), (Object)BoxesRunTime.boxToLong((long)((long)today * this.ONE_DAY_SECONDS()))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.YESTERDAY()), (Object)BoxesRunTime.boxToLong((long)((long)(today - 1) * this.ONE_DAY_SECONDS()))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.TOMORROW()), (Object)BoxesRunTime.boxToLong((long)((long)(today + 1) * this.ONE_DAY_SECONDS())))}));
    }

    public Map<String, Object> specialDatesMicros() {
        int today = this.currentDate();
        long now = DateTimeUtils$.MODULE$.instantToMicros(Instant.now());
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.EPOCH()), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.NOW()), (Object)BoxesRunTime.boxToLong((long)now)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.TODAY()), (Object)BoxesRunTime.boxToLong((long)((long)today * this.ONE_DAY_MICROSECONDS()))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.YESTERDAY()), (Object)BoxesRunTime.boxToLong((long)((long)(today - 1) * this.ONE_DAY_MICROSECONDS()))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.TOMORROW()), (Object)BoxesRunTime.boxToLong((long)((long)(today + 1) * this.ONE_DAY_MICROSECONDS())))}));
    }

    public int currentDate() {
        return Math.toIntExact(LocalDate.now().toEpochDay());
    }

    public String toStrf(String format, boolean parseString) {
        ListBuffer<DateUtils.FormatKeywordToReplace> javaPatternsToReplace = this.identifySupportedFormatsToReplaceElseThrow(format, parseString);
        return this.replaceFormats(format, javaPatternsToReplace);
    }

    public String replaceFormats(String format, ListBuffer<DateUtils.FormatKeywordToReplace> javaPatternsToReplace) {
        StringBuilder strf = new StringBuilder(format.length()).append(format);
        ((TraversableForwarder)javaPatternsToReplace.reverse()).foreach((Function1)new Serializable(strf){
            public static final long serialVersionUID = 0L;
            private final StringBuilder strf$1;

            public final Object apply(DateUtils.FormatKeywordToReplace pattern) {
                return DateUtils$.MODULE$.conversionMap().contains((Object)pattern.word()) ? this.strf$1.replace(pattern.startIndex(), pattern.endIndex(), (String)DateUtils$.MODULE$.conversionMap().apply((Object)pattern.word())) : BoxedUnit.UNIT;
            }
            {
                this.strf$1 = strf$1;
            }
        });
        return strf.toString();
    }

    public ListBuffer<DateUtils.FormatKeywordToReplace> identifySupportedFormatsToReplaceElseThrow(String format, boolean parseString) {
        BoxedUnit boxedUnit;
        Set<String> unsupportedWordContextAware = parseString ? this.unsupportedWordParseFromString() : this.unsupportedWord();
        ObjectRef sb = ObjectRef.create((Object)new StringBuilder());
        IntRef index = IntRef.create((int)0);
        ListBuffer patterns = new ListBuffer();
        new StringOps(Predef$.MODULE$.augmentString(format)).foreach((Function1)new Serializable(format, unsupportedWordContextAware, sb, index, patterns){
            public static final long serialVersionUID = 0L;
            private final String format$1;
            private final Set unsupportedWordContextAware$1;
            private final ObjectRef sb$1;
            private final IntRef index$1;
            private final ListBuffer patterns$1;

            public final void apply(char character) {
                StringBuilder stringBuilder;
                if (((StringBuilder)this.sb$1.elem).isEmpty() || BoxesRunTime.unboxToChar((Object)((StringBuilder)this.sb$1.elem).last()) == character) {
                    if (DateUtils$.MODULE$.unsupportedCharacter().apply((Object)BoxesRunTime.boxToCharacter((char)character))) {
                        throw new DateUtils.TimestampFormatConversionException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported character: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)character)})));
                    }
                    stringBuilder = ((StringBuilder)this.sb$1.elem).append(character);
                } else {
                    String word = ((StringBuilder)this.sb$1.elem).toString();
                    if (this.unsupportedWordContextAware$1.apply((Object)word)) {
                        throw new DateUtils.TimestampFormatConversionException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported word: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{word})));
                    }
                    int startIndex = this.index$1.elem - word.length();
                    this.patterns$1.$plus$eq((Object)new DateUtils.FormatKeywordToReplace(word, startIndex, startIndex + word.length()));
                    this.sb$1.elem = new StringBuilder(this.format$1.length());
                    if (DateUtils$.MODULE$.unsupportedCharacter().apply((Object)BoxesRunTime.boxToCharacter((char)character))) {
                        throw new DateUtils.TimestampFormatConversionException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported character: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)character)})));
                    }
                    stringBuilder = ((StringBuilder)this.sb$1.elem).append(character);
                }
                ++this.index$1.elem;
            }
            {
                this.format$1 = format$1;
                this.unsupportedWordContextAware$1 = unsupportedWordContextAware$1;
                this.sb$1 = sb$1;
                this.index$1 = index$1;
                this.patterns$1 = patterns$1;
            }
        });
        if (((StringBuilder)sb.elem).nonEmpty()) {
            String word = ((StringBuilder)sb.elem).toString();
            if (unsupportedWordContextAware.apply((Object)word)) {
                throw new DateUtils.TimestampFormatConversionException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported word: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{word})));
            }
            int startIndex = format.length() - word.length();
            boxedUnit = patterns.$plus$eq((Object)new DateUtils.FormatKeywordToReplace(word, startIndex, startIndex + word.length()));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return patterns;
    }

    /*
     * Loose catch block
     */
    public String tagAndGetCudfFormat(RapidsMeta<?, ?> meta, String sparkFormat, boolean parseString) {
        String strfFormat;
        block10: {
            strfFormat = null;
            TimeParserPolicy timeParserPolicy = GpuOverrides$.MODULE$.getTimeParserPolicy();
            LegacyTimeParserPolicy$ legacyTimeParserPolicy$ = LegacyTimeParserPolicy$.MODULE$;
            if (!(timeParserPolicy != null ? !timeParserPolicy.equals(legacyTimeParserPolicy$) : legacyTimeParserPolicy$ != null)) {
                strfFormat = this.toStrf(sparkFormat, parseString);
                if (GpuToTimestamp$.MODULE$.LEGACY_COMPATIBLE_FORMATS().contains((Object)sparkFormat)) {
                    boolean ansiEnabled = false;
                    if (ansiEnabled) {
                        meta.willNotWorkOnGpu("LEGACY format in ANSI mode is not supported on the GPU");
                    } else if (!meta.conf().incompatDateFormats()) {
                        meta.willNotWorkOnGpu(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LEGACY format '", "' on the GPU is not guaranteed "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sparkFormat}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"to produce the same results as Spark on CPU. Set "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "=true to force onto GPU."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RapidsConf$.MODULE$.INCOMPATIBLE_DATE_FORMATS().key()}))).toString());
                    }
                    break block10;
                }
                meta.willNotWorkOnGpu(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LEGACY format '", "' is not supported on the GPU."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sparkFormat})));
            }
            strfFormat = this.toStrf(sparkFormat, parseString);
            if (!GpuToTimestamp$.MODULE$.CORRECTED_COMPATIBLE_FORMATS().contains((Object)sparkFormat) && !meta.conf().incompatDateFormats()) {
                meta.willNotWorkOnGpu(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CORRECTED format '", "' on the GPU is not guaranteed "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sparkFormat}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"to produce the same results as Spark on CPU. Set "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "=true to force onto GPU."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RapidsConf$.MODULE$.INCOMPATIBLE_DATE_FORMATS().key()}))).toString());
            }
            catch (DateUtils.TimestampFormatConversionException timestampFormatConversionException) {
                meta.willNotWorkOnGpu(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to convert ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{timestampFormatConversionException.reason(), timestampFormatConversionException.getMessage()})));
            }
            break block10;
            catch (DateUtils.TimestampFormatConversionException timestampFormatConversionException) {
                meta.willNotWorkOnGpu(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to convert ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{timestampFormatConversionException.reason(), timestampFormatConversionException.getMessage()})));
            }
        }
        return strfFormat;
    }

    private DateUtils$() {
        MODULE$ = this;
        this.unsupportedCharacter = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapCharArray(new char[]{'k', 'K', 'z', 'V', 'c', 'F', 'W', 'Q', 'q', 'G', 'A', 'n', 'N', 'O', 'X', 'p', '\'', '[', ']', '#', '{', '}', 'Z', 'w', 'e', 'E', 'x', 'Z', 'Y'}));
        this.unsupportedWord = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"u", "uu", "uuu", "uuuu", "uuuuu", "uuuuuu", "uuuuuuu", "uuuuuuuu", "uuuuuuuuu", "uuuuuuuuuu", "y", "yyy", "yyyyy", "yyyyyy", "yyyyyyy", "yyyyyyyy", "yyyyyyyyy", "yyyyyyyyyy", "D", "DD", "DDD", "s", "m", "H", "h", "M", "MMM", "MMMM", "MMMMM", "L", "LLL", "LLLL", "LLLLL", "d", "S", "SS", "SSS", "SSSS", "SSSSS", "SSSSSSSSS", "SSSSSSS", "SSSSSSSS"}));
        this.unsupportedWordParseFromString = (Set)this.unsupportedWord().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"yy"})));
        this.conversionMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"MM"), (Object)"%m"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"LL"), (Object)"%m"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dd"), (Object)"%d"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mm"), (Object)"%M"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ss"), (Object)"%S"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"HH"), (Object)"%H"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"yy"), (Object)"%y"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"yyyy"), (Object)"%Y"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SSSSSS"), (Object)"%f")}));
        this.ONE_SECOND_MICROSECONDS = 1000000;
        this.ONE_DAY_SECONDS = 86400L;
        this.ONE_DAY_MICROSECONDS = 86400000000L;
        this.EPOCH = "epoch";
        this.NOW = "now";
        this.TODAY = "today";
        this.YESTERDAY = "yesterday";
        this.TOMORROW = "tomorrow";
    }
}

