/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import com.nvidia.spark.rapids.GpuOverrides$;
import com.nvidia.spark.rapids.GpuUnsignedIntegerType;
import com.nvidia.spark.rapids.GpuUnsignedLongType;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.TimestampType;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class DecimalUtil$ {
    public static final DecimalUtil$ MODULE$;
    private final DecimalType BooleanDecimal;

    static {
        new DecimalUtil$();
    }

    public String getNonNestedRapidsType(DataType dtype) {
        Option<String> res = this.toRapidsStringOrNull(dtype);
        return (String)res.getOrElse((Function0)new Serializable(dtype){
            public static final long serialVersionUID = 0L;
            private final DataType dtype$1;

            public final Nothing$ apply() {
                throw new IllegalArgumentException(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)this.dtype$1), " is not supported for GPU processing yet."));
            }
            {
                this.dtype$1 = dtype$1;
            }
        });
    }

    public Option<String> createCudfDecimal(DecimalType dt) {
        return this.createInternalCudfDecimal(dt.precision(), dt.scale());
    }

    public Option<String> createInternalCudfDecimal(int precision, int scale) {
        block5: {
            Some some;
            block3: {
                block4: {
                    block2: {
                        if (precision > GpuOverrides$.MODULE$.DECIMAL32_MAX_PRECISION()) break block2;
                        some = new Some((Object)"DECIMAL32");
                        break block3;
                    }
                    if (precision > GpuOverrides$.MODULE$.DECIMAL64_MAX_PRECISION()) break block4;
                    some = new Some((Object)"DECIMAL64");
                    break block3;
                }
                if (precision > GpuOverrides$.MODULE$.DECIMAL128_MAX_PRECISION()) break block5;
                some = new Some((Object)"DECIMAL128");
            }
            return some;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"precision overflow: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)precision)})));
    }

    public Option<String> toRapidsStringOrNull(DataType dtype) {
        Object object;
        DataType dataType = dtype;
        if (dataType instanceof LongType) {
            object = new Some((Object)"INT64");
        } else if (dataType instanceof DoubleType) {
            object = new Some((Object)"FLOAT64");
        } else if (dataType instanceof ByteType) {
            object = new Some((Object)"INT8");
        } else if (dataType instanceof BooleanType) {
            object = new Some((Object)"BOOL8");
        } else if (dataType instanceof ShortType) {
            object = new Some((Object)"INT16");
        } else if (dataType instanceof IntegerType) {
            object = new Some((Object)"INT32");
        } else if (dataType instanceof FloatType) {
            object = new Some((Object)"FLOAT32");
        } else if (dataType instanceof DateType) {
            object = new Some((Object)"TIMESTAMP_DAYS");
        } else if (dataType instanceof TimestampType) {
            object = new Some((Object)"TIMESTAMP_MICROSECONDS");
        } else if (dataType instanceof StringType) {
            object = new Some((Object)"STRING");
        } else if (dataType instanceof BinaryType) {
            object = new Some((Object)"LIST");
        } else if (dataType instanceof NullType) {
            object = new Some((Object)"INT8");
        } else if (dataType instanceof DecimalType) {
            DecimalType dt = (DecimalType)dtype;
            object = this.createCudfDecimal(dt);
        } else {
            object = dataType instanceof GpuUnsignedIntegerType ? new Some((Object)"UINT32") : (dataType instanceof GpuUnsignedLongType ? new Some((Object)"UINT64") : None$.MODULE$);
        }
        return object;
    }

    public int getPrecisionForIntegralType(String input) {
        String string;
        block6: {
            int n;
            block3: {
                block5: {
                    block4: {
                        block2: {
                            string = input;
                            if (!"INT8".equals(string)) break block2;
                            n = 3;
                            break block3;
                        }
                        if (!"INT16".equals(string)) break block4;
                        n = 5;
                        break block3;
                    }
                    if (!"INT32".equals(string)) break block5;
                    n = 10;
                    break block3;
                }
                if (!"INT64".equals(string)) break block6;
                n = 19;
            }
            return n;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string})));
    }

    private DecimalType BooleanDecimal() {
        return this.BooleanDecimal;
    }

    public Option<DecimalType> optionallyAsDecimalType(DataType t) {
        Object object;
        DataType dataType = t;
        if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            object = new Some((Object)decimalType);
        } else {
            boolean bl = ByteType$.MODULE$.equals(dataType) ? true : (ShortType$.MODULE$.equals(dataType) ? true : (IntegerType$.MODULE$.equals(dataType) ? true : LongType$.MODULE$.equals(dataType)));
            if (bl) {
                int prec = this.getPrecisionForIntegralType(this.getNonNestedRapidsType(t));
                object = new Some((Object)new DecimalType(prec, 0));
            } else {
                object = BooleanType$.MODULE$.equals(dataType) ? new Some((Object)this.BooleanDecimal()) : None$.MODULE$;
            }
        }
        return object;
    }

    public DecimalType asDecimalType(DataType t) {
        Option<DecimalType> option = this.optionallyAsDecimalType(t);
        if (option instanceof Some) {
            DecimalType dt;
            Some some = (Some)option;
            DecimalType decimalType = dt = (DecimalType)some.x();
            return decimalType;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Internal Error: type ", " cannot automatically be cast to a supported DecimalType"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t})));
    }

    private DecimalUtil$() {
        MODULE$ = this;
        this.BooleanDecimal = new DecimalType(1, 0);
    }
}

