/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import com.nvidia.spark.rapids.CsvFormatType$;
import com.nvidia.spark.rapids.FileFormatChecks$;
import com.nvidia.spark.rapids.GpuOverrides$;
import com.nvidia.spark.rapids.GpuTextBasedDateUtils$;
import com.nvidia.spark.rapids.RapidsConf$;
import com.nvidia.spark.rapids.RapidsMeta;
import com.nvidia.spark.rapids.ReadFileOp$;
import java.nio.charset.StandardCharsets;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.csv.GpuCsvUtils$;
import org.apache.spark.sql.catalyst.util.ParseMode;
import org.apache.spark.sql.catalyst.util.PermissiveMode$;
import org.apache.spark.sql.execution.datasources.csv.CSVOptions;
import org.apache.spark.sql.rapids.LegacyTimeParserPolicy$;
import org.apache.spark.sql.rapids.TimeParserPolicy;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;

public final class GpuCSVScan$ {
    public static final GpuCSVScan$ MODULE$;

    static {
        new GpuCSVScan$();
    }

    public void tagSupport(SparkSession sparkSession, StructType dataSchema, StructType readSchema, Map<String, String> options, RapidsMeta<?, ?> meta) {
        String string;
        CSVOptions parsedOptions = new CSVOptions(options, sparkSession.sessionState().conf().csvColumnPruning(), sparkSession.sessionState().conf().sessionLocalTimeZone(), sparkSession.sessionState().conf().columnNameOfCorruptRecord());
        if (!meta.conf().isCsvEnabled()) {
            meta.willNotWorkOnGpu(new StringBuilder().append((Object)"CSV input and output has been disabled. To enable set").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " to true"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RapidsConf$.MODULE$.ENABLE_CSV()}))).toString());
        }
        if (!meta.conf().isCsvReadEnabled()) {
            meta.willNotWorkOnGpu(new StringBuilder().append((Object)"CSV input has been disabled. To enable set").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " to true"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RapidsConf$.MODULE$.ENABLE_CSV_READ()}))).toString());
        }
        if (!parsedOptions.enforceSchema()) {
            meta.willNotWorkOnGpu("GpuCSVScan always enforces schemas");
        }
        if (dataSchema == null || dataSchema.isEmpty()) {
            meta.willNotWorkOnGpu("GpuCSVScan requires a specified data schema");
        }
        if (parsedOptions.delimiter() > '\u007f') {
            meta.willNotWorkOnGpu("GpuCSVScan does not support non-ASCII delimiters");
        }
        if (parsedOptions.quote() > '\u007f') {
            meta.willNotWorkOnGpu("GpuCSVScan does not support non-ASCII quote chars");
        }
        if (parsedOptions.comment() > '\u007f') {
            meta.willNotWorkOnGpu("GpuCSVScan does not support non-ASCII comment chars");
        }
        if (parsedOptions.escape() != '\\') {
            meta.willNotWorkOnGpu("GpuCSVScan does not support modified escape chars");
        }
        if (parsedOptions.charToEscapeQuoteEscaping().isDefined()) {
            meta.willNotWorkOnGpu("GPU CSV Parsing does not support charToEscapeQuoteEscaping");
        }
        String string2 = StandardCharsets.UTF_8.name();
        String string3 = parsedOptions.charset();
        if (string2 == null ? string3 != null : !string2.equals(string3)) {
            String string4 = StandardCharsets.US_ASCII.name();
            String string5 = parsedOptions.charset();
            if (string4 == null ? string5 != null : !string4.equals(string5)) {
                meta.willNotWorkOnGpu("GpuCSVScan only supports UTF8 encoded data");
            }
        }
        ParseMode parseMode = parsedOptions.parseMode();
        PermissiveMode$ permissiveMode$ = PermissiveMode$.MODULE$;
        if (parseMode == null ? permissiveMode$ != null : !parseMode.equals(permissiveMode$)) {
            meta.willNotWorkOnGpu("GpuCSVScan only supports Permissive CSV parsing");
        }
        boolean bl = "inf".equals(string = parsedOptions.positiveInf().toLowerCase()) ? true : ("+inf".equals(string) ? true : ("infinity".equals(string) ? true : "+infinity".equals(string)));
        if (bl) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            meta.willNotWorkOnGpu(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"the positive infinity value '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{parsedOptions.positiveInf()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" is not supported'"})).s((Seq)Nil$.MODULE$)).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        String string6 = parsedOptions.negativeInf().toLowerCase();
        boolean bl2 = "-inf".equals(string6) ? true : "-infinity".equals(string6);
        if (bl2) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            meta.willNotWorkOnGpu(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"the positive infinity value '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{parsedOptions.positiveInf()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" is not supported'"})).s((Seq)Nil$.MODULE$)).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        Set types = ((TraversableOnce)readSchema.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DataType apply(StructField x$1) {
                return x$1.dataType();
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet();
        TimeParserPolicy timeParserPolicy = GpuOverrides$.MODULE$.getTimeParserPolicy();
        LegacyTimeParserPolicy$ legacyTimeParserPolicy$ = LegacyTimeParserPolicy$.MODULE$;
        if (!(timeParserPolicy != null ? !timeParserPolicy.equals(legacyTimeParserPolicy$) : legacyTimeParserPolicy$ != null)) {
            if (types.contains((Object)DateType$.MODULE$) || types.contains((Object)TimestampType$.MODULE$)) {
                meta.willNotWorkOnGpu(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"GpuCSVScan does not support timeParserPolicy=LEGACY"})).s((Seq)Nil$.MODULE$));
            }
        }
        if (types.contains((Object)DateType$.MODULE$)) {
            GpuTextBasedDateUtils$.MODULE$.tagCudfFormat(meta, GpuCsvUtils$.MODULE$.dateFormatInRead(parsedOptions), true);
        }
        if (types.contains((Object)TimestampType$.MODULE$)) {
            meta.checkTimeZoneId(parsedOptions.timeZone().toZoneId());
            GpuTextBasedDateUtils$.MODULE$.tagCudfFormat(meta, GpuCsvUtils$.MODULE$.timestampFormatInRead(parsedOptions), true);
        }
        if (!meta.conf().isCsvFloatReadEnabled() && types.contains((Object)FloatType$.MODULE$)) {
            meta.willNotWorkOnGpu(new StringBuilder().append((Object)"CSV reading is not 100% compatible when reading floats. ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"To enable it please set ", " to true."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RapidsConf$.MODULE$.ENABLE_READ_CSV_FLOATS()}))).toString());
        }
        if (!meta.conf().isCsvDoubleReadEnabled() && types.contains((Object)DoubleType$.MODULE$)) {
            meta.willNotWorkOnGpu(new StringBuilder().append((Object)"CSV reading is not 100% compatible when reading doubles. ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"To enable it please set ", " to true."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RapidsConf$.MODULE$.ENABLE_READ_CSV_DOUBLES()}))).toString());
        }
        if (!meta.conf().isCsvDecimalReadEnabled() && types.exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(DataType x$2) {
                return x$2 instanceof DecimalType;
            }
        })) {
            meta.willNotWorkOnGpu(new StringBuilder().append((Object)"CSV reading is not 100% compatible when reading decimals. ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"To enable it please set ", " to true."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RapidsConf$.MODULE$.ENABLE_READ_CSV_DECIMALS()}))).toString());
        }
        FileFormatChecks$.MODULE$.tag(meta, readSchema, CsvFormatType$.MODULE$, ReadFileOp$.MODULE$);
    }

    private GpuCSVScan$() {
        MODULE$ = this;
    }
}

