/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import com.nvidia.spark.rapids.FileFormatChecks$;
import com.nvidia.spark.rapids.ParquetFormatType$;
import com.nvidia.spark.rapids.RapidsConf$;
import com.nvidia.spark.rapids.RapidsMeta;
import com.nvidia.spark.rapids.WriteFileOp$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.TrampolineUtil$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOptions;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;

public final class GpuParquetFileFormat$ {
    public static final GpuParquetFileFormat$ MODULE$;

    static {
        new GpuParquetFileFormat$();
    }

    public void tagGpuSupport(RapidsMeta<?, ?> meta, SparkSession spark, Map<String, String> options, StructType schema) {
        boolean schemaHasTimestamps;
        SQLConf sqlConf = spark.sessionState().conf();
        ParquetOptions parquetOptions = new ParquetOptions(options, sqlConf);
        String columnEncryption = (String)options.getOrElse((Object)"parquet.encryption.column.keys", (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        String footerEncryption = (String)options.getOrElse((Object)"parquet.encryption.footer.key", (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        if (!columnEncryption.isEmpty() || !footerEncryption.isEmpty()) {
            meta.willNotWorkOnGpu("Encryption is not yet supported on GPU. If encrypted Parquet writes are not required unset the \"parquet.encryption.column.keys\" and \"parquet.encryption.footer.key\" in Parquet options");
        }
        if (!meta.conf().isParquetEnabled()) {
            meta.willNotWorkOnGpu(new StringBuilder().append((Object)"Parquet input and output has been disabled. To enable set").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " to true"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RapidsConf$.MODULE$.ENABLE_PARQUET()}))).toString());
        }
        if (!meta.conf().isParquetWriteEnabled()) {
            meta.willNotWorkOnGpu(new StringBuilder().append((Object)"Parquet output has been disabled. To enable set").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " to true"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RapidsConf$.MODULE$.ENABLE_PARQUET_WRITE()}))).toString());
        }
        FileFormatChecks$.MODULE$.tag(meta, schema, ParquetFormatType$.MODULE$, WriteFileOp$.MODULE$);
        this.parseCompressionType(parquetOptions.compressionCodecClassName()).getOrElse((Function0)new Serializable(meta, parquetOptions){
            public static final long serialVersionUID = 0L;
            private final RapidsMeta meta$1;
            private final ParquetOptions parquetOptions$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.meta$1.willNotWorkOnGpu(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"compression codec ", " is not supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.parquetOptions$1.compressionCodecClassName()})));
            }
            {
                this.meta$1 = meta$1;
                this.parquetOptions$1 = parquetOptions$1;
            }
        });
        if (sqlConf.writeLegacyParquetFormat()) {
            meta.willNotWorkOnGpu("Spark legacy format is not supported");
        }
        if (!meta.conf().isParquetInt96WriteEnabled()) {
            Enumeration.Value value = sqlConf.parquetOutputTimestampType();
            Enumeration.Value value2 = SQLConf.ParquetOutputTimestampType$.MODULE$.INT96();
            if (!(value != null ? !value.equals(value2) : value2 != null)) {
                meta.willNotWorkOnGpu(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Writing INT96 is disabled, if you want to enable it turn it on by "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"setting the ", " to true. NOTE: check "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RapidsConf$.MODULE$.ENABLE_PARQUET_INT96_WRITE()}))).append((Object)"out the compatibility.md to know about the limitations associated with INT96 writer").toString());
            }
        }
        if ((schemaHasTimestamps = schema.exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructField field) {
                return TrampolineUtil$.MODULE$.dataTypeExistsRecursively(field.dataType(), (Function1<DataType, Object>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(DataType x$1) {
                        return x$1 instanceof TimestampType;
                    }
                });
            }
        })) && !this.isOutputTimestampTypeSupported(sqlConf.parquetOutputTimestampType())) {
            meta.willNotWorkOnGpu(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Output timestamp type "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sqlConf.parquetOutputTimestampType()}))).toString());
        }
        boolean schemaHasDates = schema.exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructField field) {
                return TrampolineUtil$.MODULE$.dataTypeExistsRecursively(field.dataType(), (Function1<DataType, Object>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(DataType x$2) {
                        return x$2 instanceof DateType;
                    }
                });
            }
        });
    }

    public Option<String> parseCompressionType(String compressionType) {
        String string = compressionType;
        boolean bl = "NONE".equals(string) ? true : "UNCOMPRESSED".equals(string);
        Object object = bl ? new Some((Object)"NONE") : ("SNAPPY".equals(string) ? new Some((Object)"SNAPPY") : None$.MODULE$);
        return object;
    }

    public boolean isOutputTimestampTypeSupported(Enumeration.Value outputTimestampType) {
        boolean bl;
        Enumeration.Value value = outputTimestampType;
        Enumeration.Value value2 = SQLConf.ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MICROS();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            bl = true;
        } else {
            Enumeration.Value value4 = SQLConf.ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MILLIS();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                bl = true;
            } else {
                Enumeration.Value value6 = SQLConf.ParquetOutputTimestampType$.MODULE$.INT96();
                Enumeration.Value value7 = value;
                bl = !(value6 != null ? !value6.equals(value7) : value7 != null);
            }
        }
        boolean bl2 = bl;
        return bl2;
    }

    private GpuParquetFileFormat$() {
        MODULE$ = this;
    }
}

