/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import com.nvidia.spark.rapids.DataTypeUtils$;
import com.nvidia.spark.rapids.FileFormatChecks$;
import com.nvidia.spark.rapids.ParquetFormatType$;
import com.nvidia.spark.rapids.RapidsConf$;
import com.nvidia.spark.rapids.RapidsMeta;
import com.nvidia.spark.rapids.ReadFileOp$;
import org.apache.spark.sql.RuntimeConfig;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.TrampolineUtil$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class GpuParquetScan$ {
    public static final GpuParquetScan$ MODULE$;

    static {
        new GpuParquetScan$();
    }

    public void tagSupport(SparkSession sparkSession, StructType readSchema, RapidsMeta<?, ?> meta) {
        RuntimeConfig sqlConf = sparkSession.conf();
        if (!meta.conf().isParquetEnabled()) {
            meta.willNotWorkOnGpu(new StringBuilder().append((Object)"Parquet input and output has been disabled. To enable set").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " to true"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RapidsConf$.MODULE$.ENABLE_PARQUET()}))).toString());
        }
        if (!meta.conf().isParquetReadEnabled()) {
            meta.willNotWorkOnGpu(new StringBuilder().append((Object)"Parquet input has been disabled. To enable set").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " to true"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RapidsConf$.MODULE$.ENABLE_PARQUET_READ()}))).toString());
        }
        FileFormatChecks$.MODULE$.tag(meta, readSchema, ParquetFormatType$.MODULE$, ReadFileOp$.MODULE$);
        boolean schemaHasTimestamps = readSchema.exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructField field) {
                return TrampolineUtil$.MODULE$.dataTypeExistsRecursively(field.dataType(), (Function1<DataType, Object>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(DataType x$1) {
                        return x$1 instanceof TimestampType;
                    }
                });
            }
        });
        boolean schemaMightNeedNestedRebase = readSchema.exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructField field) {
                return DataTypeUtils$.MODULE$.isNestedType(field.dataType()) ? TrampolineUtil$.MODULE$.dataTypeExistsRecursively(field.dataType(), (Function1<DataType, Object>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(DataType dt) {
                        return GpuParquetScan$.MODULE$.com$nvidia$spark$rapids$GpuParquetScan$$isTsOrDate$1(dt);
                    }
                }) : false;
            }
        });
        if (schemaHasTimestamps && sparkSession.sessionState().conf().isParquetINT96TimestampConversion()) {
            meta.willNotWorkOnGpu("GpuParquetScan does not support int96 timestamp conversion");
        }
    }

    public long com$nvidia$spark$rapids$GpuParquetScan$$numNodesEstimate(DataType dt) {
        long l;
        DataType dataType = dt;
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            l = 1L + BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])fields).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final long apply(StructField f) {
                    return GpuParquetScan$.MODULE$.com$nvidia$spark$rapids$GpuParquetScan$$numNodesEstimate(f.dataType());
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        } else if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType elementType = arrayType.elementType();
            l = 2L + this.com$nvidia$spark$rapids$GpuParquetScan$$numNodesEstimate(elementType);
        } else if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            l = 2L + this.com$nvidia$spark$rapids$GpuParquetScan$$numNodesEstimate(keyType) + this.com$nvidia$spark$rapids$GpuParquetScan$$numNodesEstimate(valueType);
        } else {
            l = 1L;
        }
        return l;
    }

    public final boolean com$nvidia$spark$rapids$GpuParquetScan$$isTsOrDate$1(DataType dt) {
        DataType dataType = dt;
        boolean bl = TimestampType$.MODULE$.equals(dataType) ? true : DateType$.MODULE$.equals(dataType);
        boolean bl2 = bl;
        return bl2;
    }

    private GpuParquetScan$() {
        MODULE$ = this;
    }
}

