/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import com.nvidia.spark.rapids.DateUtils;
import com.nvidia.spark.rapids.DateUtils$;
import com.nvidia.spark.rapids.GpuOverrides$;
import com.nvidia.spark.rapids.RapidsConf$;
import com.nvidia.spark.rapids.RapidsMeta;
import org.apache.spark.sql.rapids.GpuToTimestamp$;
import org.apache.spark.sql.rapids.LegacyTimeParserPolicy$;
import org.apache.spark.sql.rapids.TimeParserPolicy;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;

public final class GpuTextBasedDateUtils$ {
    public static final GpuTextBasedDateUtils$ MODULE$;
    private final Set<String> com$nvidia$spark$rapids$GpuTextBasedDateUtils$$supportedDateFormats;
    private final Set<String> supportedTsPortionFormats;

    static {
        new GpuTextBasedDateUtils$();
    }

    public Set<String> com$nvidia$spark$rapids$GpuTextBasedDateUtils$$supportedDateFormats() {
        return this.com$nvidia$spark$rapids$GpuTextBasedDateUtils$$supportedDateFormats;
    }

    private Set<String> supportedTsPortionFormats() {
        return this.supportedTsPortionFormats;
    }

    /*
     * Loose catch block
     */
    public void tagCudfFormat(RapidsMeta<?, ?> meta, String sparkFormat, boolean parseString) {
        block10: {
            TimeParserPolicy timeParserPolicy = GpuOverrides$.MODULE$.getTimeParserPolicy();
            LegacyTimeParserPolicy$ legacyTimeParserPolicy$ = LegacyTimeParserPolicy$.MODULE$;
            if (!(timeParserPolicy != null ? !timeParserPolicy.equals(legacyTimeParserPolicy$) : legacyTimeParserPolicy$ != null)) {
                this.toCudfFormats(sparkFormat, parseString);
                if (GpuToTimestamp$.MODULE$.LEGACY_COMPATIBLE_FORMATS().contains((Object)sparkFormat)) {
                    if (!meta.conf().incompatDateFormats()) {
                        meta.willNotWorkOnGpu(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LEGACY format '", "' on the GPU is not guaranteed "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sparkFormat}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"to produce the same results as Spark on CPU. Set "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "=true to force onto GPU."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RapidsConf$.MODULE$.INCOMPATIBLE_DATE_FORMATS().key()}))).toString());
                    }
                    break block10;
                }
                meta.willNotWorkOnGpu(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LEGACY format '", "' is not supported on the GPU."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sparkFormat})));
            }
            String[] parts = sparkFormat.split("'T'", 2);
            if (Predef$.MODULE$.refArrayOps((Object[])parts).isEmpty()) {
                meta.willNotWorkOnGpu(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"the timestamp format '", "' is not supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sparkFormat})));
            }
            if (Predef$.MODULE$.refArrayOps((Object[])parts).headOption().exists((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String h) {
                    return !GpuTextBasedDateUtils$.MODULE$.com$nvidia$spark$rapids$GpuTextBasedDateUtils$$supportedDateFormats().contains((Object)h);
                }
            })) {
                meta.willNotWorkOnGpu(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"the timestamp format '", "' is not supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sparkFormat})));
            }
            if (parts.length > 1 && !this.supportedTsPortionFormats().contains((Object)parts[1])) {
                meta.willNotWorkOnGpu(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"the timestamp format '", "' is not supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sparkFormat})));
            }
            this.toCudfFormats(sparkFormat, parseString);
            catch (DateUtils.TimestampFormatConversionException timestampFormatConversionException) {
                meta.willNotWorkOnGpu(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to convert ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{timestampFormatConversionException.reason(), timestampFormatConversionException.getMessage()})));
            }
            break block10;
            catch (DateUtils.TimestampFormatConversionException timestampFormatConversionException) {
                meta.willNotWorkOnGpu(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to convert ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{timestampFormatConversionException.reason(), timestampFormatConversionException.getMessage()})));
            }
        }
    }

    public Seq<String> toCudfFormats(String sparkFormat, boolean parseString) {
        Seq seq;
        boolean hasZsuffix = sparkFormat.endsWith("Z");
        String formatRoot = hasZsuffix ? sparkFormat.substring(0, sparkFormat.length() - 1) : sparkFormat;
        String cudfSupportedFormat = formatRoot.replace("'T'", "T").replace("[.SSSXXX]", "").replace("[.SSS][XXX]", "").replace("[.SSS]", "").replace("[.SSSSSS]", "").replace(".SSSXXX", "").replace(".SSS", "").replace("[:ss]", "");
        String cudfFormat = DateUtils$.MODULE$.toStrf(cudfSupportedFormat, parseString);
        String suffix = hasZsuffix ? "Z" : "";
        Seq optionalFractional = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[.SSS][XXX]", "[.SSS]", "[.SSSSSS]", "[.SSS][XXX]", ".SSSXXX", ".SSS"}));
        if (optionalFractional.exists((Function1)new Serializable(formatRoot){
            public static final long serialVersionUID = 0L;
            private final String formatRoot$1;

            public final boolean apply(String x$1) {
                return this.formatRoot$1.endsWith(x$1);
            }
            {
                this.formatRoot$1 = formatRoot$1;
            }
        })) {
            String cudfFormat1 = new StringBuilder().append((Object)cudfFormat).append((Object)suffix).toString();
            String cudfFormat2 = new StringBuilder().append((Object)cudfFormat).append((Object)".%f").append((Object)suffix).toString();
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{cudfFormat1, cudfFormat2}));
        } else {
            seq = formatRoot.endsWith("[:ss]") ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)cudfFormat).append((Object)":%S").append((Object)suffix).toString()})) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{cudfFormat}));
        }
        Seq baseFormats = seq;
        int pos = ((String)baseFormats.head()).indexOf(84);
        Seq formatsIncludingDateOnly = pos == -1 ? baseFormats : (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((String)baseFormats.head()).substring(0, pos)}))).$plus$plus((GenTraversableOnce)baseFormats, Seq$.MODULE$.canBuildFrom());
        ListBuffer formats = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        formatsIncludingDateOnly.foreach((Function1)new Serializable(formats){
            public static final long serialVersionUID = 0L;
            private final ListBuffer formats$1;

            public final ListBuffer<String> apply(String fmt) {
                Object object = fmt.contains(":%S") && !fmt.contains("%f") ? this.formats$1.$plus$eq((Object)fmt.replace(":%S", "")) : BoxedUnit.UNIT;
                return this.formats$1.$plus$eq((Object)fmt);
            }
            {
                this.formats$1 = formats$1;
            }
        });
        return formats;
    }

    private GpuTextBasedDateUtils$() {
        MODULE$ = this;
        this.com$nvidia$spark$rapids$GpuTextBasedDateUtils$$supportedDateFormats = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"yyyy-MM-dd", "yyyy/MM/dd", "yyyy-MM", "yyyy/MM", "MM-yyyy", "MM/yyyy", "MM-dd-yyyy", "MM/dd/yyyy", "dd-MM-yyyy", "dd/MM/yyyy"}));
        this.supportedTsPortionFormats = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"HH:mm:ss.SSSXXX", "HH:mm:ss[.SSS][XXX]", "HH:mm:ss[.SSSXXX]", "HH:mm", "HH:mm:ss", "HH:mm[:ss]", "HH:mm:ss.SSS", "HH:mm:ss[.SSS]"}));
    }
}

