/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.json.rapids;

import com.nvidia.spark.rapids.FileFormatChecks$;
import com.nvidia.spark.rapids.GpuTextBasedDateUtils$;
import com.nvidia.spark.rapids.JsonFormatType$;
import com.nvidia.spark.rapids.RapidsConf$;
import com.nvidia.spark.rapids.RapidsMeta;
import com.nvidia.spark.rapids.ReadFileOp$;
import java.nio.charset.StandardCharsets;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JSONOptionsInRead;
import org.apache.spark.sql.catalyst.json.rapids.GpuJsonUtils$;
import org.apache.spark.sql.catalyst.util.ParseMode;
import org.apache.spark.sql.catalyst.util.PermissiveMode$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class GpuJsonScan$ {
    public static final GpuJsonScan$ MODULE$;

    static {
        new GpuJsonScan$();
    }

    public void tagSupport(SparkSession sparkSession, StructType dataSchema, StructType readSchema, Map<String, String> options, RapidsMeta<?, ?> meta) {
        JSONOptionsInRead parsedOptions = new JSONOptionsInRead(options, sparkSession.sessionState().conf().sessionLocalTimeZone(), sparkSession.sessionState().conf().columnNameOfCorruptRecord());
        if (!meta.conf().isJsonEnabled()) {
            meta.willNotWorkOnGpu(new StringBuilder().append((Object)"JSON input and output has been disabled. To enable set ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " to true"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RapidsConf$.MODULE$.ENABLE_JSON()}))).toString());
        }
        if (!meta.conf().isJsonReadEnabled()) {
            meta.willNotWorkOnGpu(new StringBuilder().append((Object)"JSON input has been disabled. To enable set ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " to true. Please note that, currently json reader does "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RapidsConf$.MODULE$.ENABLE_JSON_READ()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"not support column prune, so user must specify the full schema or just let spark to "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"infer the schema"})).s((Seq)Nil$.MODULE$)).toString());
        }
        if (parsedOptions.multiLine()) {
            meta.willNotWorkOnGpu("GpuJsonScan does not support multiLine");
        }
        if (parsedOptions.allowComments()) {
            meta.willNotWorkOnGpu("GpuJsonScan does not support allowComments");
        }
        if (parsedOptions.allowUnquotedFieldNames()) {
            meta.willNotWorkOnGpu("GpuJsonScan does not support allowUnquotedFieldNames");
        }
        if (BoxesRunTime.unboxToBoolean((Object)options.get((Object)"allowSingleQuotes").map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$1) {
                return new StringOps(Predef$.MODULE$.augmentString(x$1)).toBoolean();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        }))) {
            meta.willNotWorkOnGpu("GpuJsonScan does not support allowSingleQuotes");
        }
        if (parsedOptions.allowBackslashEscapingAnyCharacter()) {
            meta.willNotWorkOnGpu("GpuJsonScan does not support allowBackslashEscapingAnyCharacter");
        }
        if (parsedOptions.dropFieldIfAllNull()) {
            meta.willNotWorkOnGpu("GpuJsonScan does not support dropFieldIfAllNull");
        }
        ParseMode parseMode = parsedOptions.parseMode();
        PermissiveMode$ permissiveMode$ = PermissiveMode$.MODULE$;
        if (parseMode == null ? permissiveMode$ != null : !parseMode.equals(permissiveMode$)) {
            meta.willNotWorkOnGpu("GpuJsonScan only supports Permissive JSON parsing");
        }
        Object object = parsedOptions.lineSeparator().getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "\n";
            }
        });
        String string = "\n";
        if (object == null ? string != null : !object.equals(string)) {
            meta.willNotWorkOnGpu("GpuJsonScan only supports \"\\n\" as a line separator");
        }
        parsedOptions.encoding().foreach((Function1)new Serializable(meta){
            public static final long serialVersionUID = 0L;
            private final RapidsMeta meta$1;

            public final void apply(String enc) {
                String string = enc;
                String string2 = StandardCharsets.UTF_8.name();
                if (string == null ? string2 != null : !string.equals(string2)) {
                    String string3 = enc;
                    String string4 = StandardCharsets.US_ASCII.name();
                    if (string3 == null ? string4 != null : !string3.equals(string4)) {
                        this.meta$1.willNotWorkOnGpu("GpuJsonScan only supports UTF8 or US-ASCII encoded data");
                    }
                }
            }
            {
                this.meta$1 = meta$1;
            }
        });
        Seq types = (Seq)readSchema.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DataType apply(StructField x$2) {
                return x$2.dataType();
            }
        }, Seq$.MODULE$.canBuildFrom());
        if (types.contains((Object)DateType$.MODULE$)) {
            GpuTextBasedDateUtils$.MODULE$.tagCudfFormat(meta, GpuJsonUtils$.MODULE$.dateFormatInRead((JSONOptions)parsedOptions), true);
        }
        if (types.contains((Object)TimestampType$.MODULE$)) {
            meta.checkTimeZoneId(parsedOptions.timeZone().toZoneId());
            GpuTextBasedDateUtils$.MODULE$.tagCudfFormat(meta, GpuJsonUtils$.MODULE$.timestampFormatInRead((JSONOptions)parsedOptions), true);
        }
        if (!meta.conf().isJsonFloatReadEnabled() && types.contains((Object)FloatType$.MODULE$)) {
            meta.willNotWorkOnGpu(new StringBuilder().append((Object)"JSON reading is not 100% compatible when reading floats. ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"To enable it please set ", " to true."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RapidsConf$.MODULE$.ENABLE_READ_JSON_FLOATS()}))).toString());
        }
        if (!meta.conf().isJsonDoubleReadEnabled() && types.contains((Object)DoubleType$.MODULE$)) {
            meta.willNotWorkOnGpu(new StringBuilder().append((Object)"JSON reading is not 100% compatible when reading doubles. ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"To enable it please set ", " to true."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RapidsConf$.MODULE$.ENABLE_READ_JSON_DOUBLES()}))).toString());
        }
        if (!meta.conf().isJsonDecimalReadEnabled() && types.exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(DataType x$3) {
                return x$3 instanceof DecimalType;
            }
        })) {
            meta.willNotWorkOnGpu(new StringBuilder().append((Object)"JSON reading is not 100% compatible when reading decimals. ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"To enable it please set ", " to true."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RapidsConf$.MODULE$.ENABLE_READ_JSON_DECIMALS()}))).toString());
        }
        dataSchema.getFieldIndex(parsedOptions.columnNameOfCorruptRecord()).foreach((Function1)new Serializable(dataSchema, meta){
            public static final long serialVersionUID = 0L;
            private final StructType dataSchema$1;
            private final RapidsMeta meta$1;

            public final void apply(int corruptFieldIndex) {
                this.apply$mcVI$sp(corruptFieldIndex);
            }

            public void apply$mcVI$sp(int corruptFieldIndex) {
                StructField f = this.dataSchema$1.apply(corruptFieldIndex);
                DataType dataType = f.dataType();
                StringType$ stringType$ = StringType$.MODULE$;
                if ((dataType != null ? !dataType.equals(stringType$) : stringType$ != null) || !f.nullable()) {
                    this.meta$1.willNotWorkOnGpu("GpuJsonScan does not support Corrupt Record which must be string type and nullable");
                }
            }
            {
                this.dataSchema$1 = dataSchema$1;
                this.meta$1 = meta$1;
            }
        });
        if (readSchema.length() == 1) {
            String string2 = ((StructField)readSchema.head()).name();
            String string3 = parsedOptions.columnNameOfCorruptRecord();
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                meta.willNotWorkOnGpu("GpuJsonScan does not support Corrupt Record");
            }
        }
        FileFormatChecks$.MODULE$.tag(meta, readSchema, JsonFormatType$.MODULE$, ReadFileOp$.MODULE$);
    }

    private GpuJsonScan$() {
        MODULE$ = this;
    }
}

