/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.rapids;

import com.nvidia.spark.rapids.GpuOverrides$;
import org.apache.spark.sql.types.DecimalType;
import scala.math.package$;

public final class GpuDecimalDivide$ {
    public static final GpuDecimalDivide$ MODULE$;

    static {
        new GpuDecimalDivide$();
    }

    public int lhsNeededScale(DecimalType rhs, DecimalType outputType) {
        return outputType.scale() + rhs.scale() + 1;
    }

    public int lhsNeededPrecision(DecimalType lhs, DecimalType rhs, DecimalType outputType) {
        int neededLhsScale = this.lhsNeededScale(rhs, outputType);
        return lhs.precision() - lhs.scale() + neededLhsScale;
    }

    public int nonRoundedIntermediateArgPrecision(DecimalType lhs, DecimalType rhs, DecimalType outputType) {
        int neededLhsPrecision = this.lhsNeededPrecision(lhs, rhs, outputType);
        return package$.MODULE$.max(neededLhsPrecision, rhs.precision());
    }

    public int intermediateArgPrecision(DecimalType lhs, DecimalType rhs, DecimalType outputType) {
        return package$.MODULE$.min(this.nonRoundedIntermediateArgPrecision(lhs, rhs, outputType), GpuOverrides$.MODULE$.DECIMAL128_MAX_PRECISION());
    }

    public DecimalType intermediateLhsType(DecimalType lhs, DecimalType rhs, DecimalType outputType) {
        int precision = this.intermediateArgPrecision(lhs, rhs, outputType);
        int scale = package$.MODULE$.min(this.lhsNeededScale(rhs, outputType), precision);
        return new DecimalType(precision, scale);
    }

    public DecimalType intermediateRhsType(DecimalType lhs, DecimalType rhs, DecimalType outputType) {
        int precision = this.intermediateArgPrecision(lhs, rhs, outputType);
        return new DecimalType(precision, rhs.scale());
    }

    public DecimalType intermediateResultType(DecimalType outputType) {
        return new DecimalType(package$.MODULE$.min(outputType.precision() + 1, GpuOverrides$.MODULE$.DECIMAL128_MAX_PRECISION()), package$.MODULE$.min(outputType.scale() + 1, GpuOverrides$.MODULE$.DECIMAL128_MAX_PRECISION()));
    }

    private GpuDecimalDivide$() {
        MODULE$ = this;
    }
}

