/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.rapids;

import com.nvidia.spark.rapids.GpuOverrides$;
import java.math.BigInteger;
import org.apache.spark.sql.types.DecimalType;
import scala.MatchError;
import scala.Tuple2;
import scala.math.package$;

public final class GpuDecimalMultiply$ {
    public static final GpuDecimalMultiply$ MODULE$;
    private BigInteger max128Int;
    private BigInteger min128Int;
    private volatile byte bitmap$0;

    static {
        new GpuDecimalMultiply$();
    }

    private BigInteger max128Int$lzycompute() {
        GpuDecimalMultiply$ gpuDecimalMultiply$ = this;
        synchronized (gpuDecimalMultiply$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.max128Int = new BigInteger(new byte[]{(byte)2}).pow(127).subtract(BigInteger.ONE);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.max128Int;
        }
    }

    private BigInteger min128Int$lzycompute() {
        GpuDecimalMultiply$ gpuDecimalMultiply$ = this;
        synchronized (gpuDecimalMultiply$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.min128Int = new BigInteger(new byte[]{(byte)2}).pow(127).negate();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.min128Int;
        }
    }

    public Tuple2<Object, Object> lhsRhsNeededScales(DecimalType lhs, DecimalType rhs, DecimalType outputType) {
        Tuple2.mcII.sp sp2;
        int cudfIntermediateScale = lhs.scale() + rhs.scale();
        int requiredIntermediateScale = outputType.scale() + 1;
        if (requiredIntermediateScale > cudfIntermediateScale) {
            int neededScaleDiff = requiredIntermediateScale - cudfIntermediateScale;
            int addToLhs = 0;
            int addToRhs = 0;
            int precisionDiff = lhs.precision() - rhs.precision();
            if (precisionDiff > 0) {
                addToRhs = package$.MODULE$.min(precisionDiff, neededScaleDiff);
            } else {
                addToLhs = package$.MODULE$.min(package$.MODULE$.abs(precisionDiff), neededScaleDiff);
            }
            int stillNeeded = neededScaleDiff - (addToLhs + addToRhs);
            if (stillNeeded > 0) {
                int l = stillNeeded / 2;
                int r = stillNeeded - l;
                addToLhs += l;
                addToRhs += r;
            }
            sp2 = new Tuple2.mcII.sp(lhs.scale() + addToLhs, rhs.scale() + addToRhs);
        } else {
            sp2 = new Tuple2.mcII.sp(lhs.scale(), rhs.scale());
        }
        return sp2;
    }

    public int nonRoundedIntermediatePrecision(DecimalType l, DecimalType r, DecimalType outputType) {
        Tuple2<Object, Object> tuple2 = this.lhsRhsNeededScales(l, r, outputType);
        if (tuple2 != null) {
            Tuple2.mcII.sp sp2;
            int lhsScale = tuple2._1$mcI$sp();
            int rhsScale = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(lhsScale, rhsScale);
            int lhsScale2 = sp3._1$mcI$sp();
            int rhsScale2 = sp3._2$mcI$sp();
            int lhsPrecision = l.precision() - l.scale() + lhsScale2;
            int rhsPrecision = r.precision() - r.scale() + rhsScale2;
            return package$.MODULE$.max(package$.MODULE$.max(lhsPrecision, rhsPrecision), outputType.precision() + 1);
        }
        throw new MatchError(tuple2);
    }

    public int intermediatePrecision(DecimalType lhs, DecimalType rhs, DecimalType outputType) {
        return package$.MODULE$.min(this.nonRoundedIntermediatePrecision(lhs, rhs, outputType), GpuOverrides$.MODULE$.DECIMAL128_MAX_PRECISION());
    }

    public Tuple2<DecimalType, DecimalType> intermediateLhsRhsTypes(DecimalType lhs, DecimalType rhs, DecimalType outputType) {
        int precision = this.intermediatePrecision(lhs, rhs, outputType);
        Tuple2<Object, Object> tuple2 = this.lhsRhsNeededScales(lhs, rhs, outputType);
        if (tuple2 != null) {
            Tuple2.mcII.sp sp2;
            int lhsScale = tuple2._1$mcI$sp();
            int rhsScale = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(lhsScale, rhsScale);
            int lhsScale2 = sp3._1$mcI$sp();
            int rhsScale2 = sp3._2$mcI$sp();
            return new Tuple2((Object)new DecimalType(precision, lhsScale2), (Object)new DecimalType(precision, rhsScale2));
        }
        throw new MatchError(tuple2);
    }

    public DecimalType intermediateResultType(DecimalType lhs, DecimalType rhs, DecimalType outputType) {
        int precision = this.intermediatePrecision(lhs, rhs, outputType);
        return new DecimalType(precision, package$.MODULE$.min(outputType.scale() + 1, GpuOverrides$.MODULE$.DECIMAL128_MAX_PRECISION()));
    }

    private BigInteger max128Int() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.max128Int$lzycompute() : this.max128Int;
    }

    private BigInteger min128Int() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.min128Int$lzycompute() : this.min128Int;
    }

    private GpuDecimalMultiply$() {
        MODULE$ = this;
    }
}

