/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.rapids;

import com.nvidia.spark.rapids.BinaryExprMeta;
import com.nvidia.spark.rapids.CudfRegexTranspiler;
import com.nvidia.spark.rapids.DataFromReplacementRule;
import com.nvidia.spark.rapids.GpuOverrides$;
import com.nvidia.spark.rapids.RapidsConf;
import com.nvidia.spark.rapids.RapidsMeta;
import com.nvidia.spark.rapids.RegexSplitMode$;
import com.nvidia.spark.rapids.RegexUnsupportedException;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.unsafe.types.UTF8String;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001a4Q!\u0001\u0002\u0002\u00025\u00111d\u0015;sS:<7\u000b\u001d7jiJ+wMQ5oCJLX\t\u001f9NKR\f'BA\u0002\u0005\u0003\u0019\u0011\u0018\r]5eg*\u0011QAB\u0001\u0004gFd'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001U\u0011abG\n\u0003\u0001=\u00012\u0001E\f\u001a\u001b\u0005\t\"BA\u0002\u0013\u0015\t91C\u0003\u0002\u0015+\u00051aN^5eS\u0006T\u0011AF\u0001\u0004G>l\u0017B\u0001\r\u0012\u00059\u0011\u0015N\\1ss\u0016C\bO]'fi\u0006\u0004\"AG\u000e\r\u0001\u0011)A\u0004\u0001b\u0001;\t)\u0011J\u0014)V)F\u0011a\u0004\n\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\b\u001d>$\b.\u001b8h!\t)#&D\u0001'\u0015\t9\u0003&A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0015\u0005\u0003!\u0019\u0017\r^1msN$\u0018BA\u0016'\u0005A\u0011\u0015N\\1ss\u0016C\bO]3tg&|g\u000eC\u0005.\u0001\t\u0005\t\u0015!\u0003\u001a]\u0005!Q\r\u001f9s\u0013\ty\u0003'A\u0004xe\u0006\u0004\b/\u001a3\n\u0005E\n\"A\u0003*ba&$7/T3uC\"I1\u0007\u0001B\u0001B\u0003%AgN\u0001\u0005G>tg\r\u0005\u0002\u0011k%\u0011a'\u0005\u0002\u000b%\u0006\u0004\u0018\u000eZ:D_:4\u0017BA\u001a1\u0011%I\u0004A!A!\u0002\u0013Q\u0014*\u0001\u0004qCJ,g\u000e\u001e\t\u0004?mj\u0014B\u0001\u001f!\u0005\u0019y\u0005\u000f^5p]B\u001aa\bQ$\u0011\tA\u0001tH\u0012\t\u00035\u0001#\u0011\"\u0011\u001d\u0002\u0002\u0003\u0005)\u0011\u0001\"\u0003\u0007}#s'\u0005\u0002\u001f\u0007B\u0011q\u0004R\u0005\u0003\u000b\u0002\u00121!\u00118z!\tQr\tB\u0005Iq\u0005\u0005\t\u0011!B\u0001\u0005\n\u0019q\f\n\u001d\n\u0005e\u0002\u0004\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011\u0002'\u0002\tI,H.\u001a\t\u0003!5K!AT\t\u0003/\u0011\u000bG/\u0019$s_6\u0014V\r\u001d7bG\u0016lWM\u001c;Sk2,\u0007\"\u0002)\u0001\t\u0003\t\u0016A\u0002\u001fj]&$h\bF\u0003S)V3f\fE\u0002T\u0001ei\u0011A\u0001\u0005\u0006[=\u0003\r!\u0007\u0005\u0006g=\u0003\r\u0001\u000e\u0005\u0006s=\u0003\ra\u0016\t\u0004?mB\u0006gA-\\;B!\u0001\u0003\r.]!\tQ2\fB\u0005B-\u0006\u0005\t\u0011!B\u0001\u0005B\u0011!$\u0018\u0003\n\u0011Z\u000b\t\u0011!A\u0003\u0002\tCQaS(A\u00021CQ\u0001\u0019\u0001\u0005\u0002\u0005\f1b\u00195fG.\u0014VmZ#yaR\u0011!\r\u001d\t\u0004?m\u001a\u0007\u0003B\u0010eM6L!!\u001a\u0011\u0003\rQ+\b\u000f\\33!\t9'N\u0004\u0002 Q&\u0011\u0011\u000eI\u0001\u0007!J,G-\u001a4\n\u0005-d'AB*ue&twM\u0003\u0002jAA\u0011qD\\\u0005\u0003_\u0002\u0012qAQ8pY\u0016\fg\u000eC\u0003r?\u0002\u0007!/A\u0005eK2LW.\u0012=qeB\u0011Qe]\u0005\u0003i\u001a\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0011\u00151\b\u0001\"\u0001x\u0003\u0001\"\bN]8x+:\u001c\u0007.Z2lK\u0012$U\r\\5nSR,'/\u0012=dKB$\u0018n\u001c8\u0015\u0003y\u0001")
public abstract class StringSplitRegBinaryExpMeta<INPUT extends BinaryExpression>
extends BinaryExprMeta<INPUT> {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Tuple2<String, Object>> checkRegExp(Expression delimExpr) {
        BoxedUnit boxedUnit;
        CudfRegexTranspiler transpiler;
        Option<String> option;
        String pattern = "";
        boolean isRegExp = false;
        Option<Literal> delim = GpuOverrides$.MODULE$.extractLit(delimExpr);
        if (delim.isEmpty()) {
            this.willNotWorkOnGpu("Only literal delimiter patterns are supported");
            return new Some((Object)new Tuple2((Object)pattern, (Object)BoxesRunTime.boxToBoolean((boolean)isRegExp)));
        }
        UTF8String utf8Str = (UTF8String)((Literal)delim.get()).value();
        if (utf8Str == null) {
            this.willNotWorkOnGpu("Delimiter pattern is null");
            return new Some((Object)new Tuple2((Object)pattern, (Object)BoxesRunTime.boxToBoolean((boolean)isRegExp)));
        }
        if (utf8Str.numChars() == 0) {
            this.willNotWorkOnGpu("An empty delimiter pattern is not supported");
        }
        if ((option = (transpiler = new CudfRegexTranspiler(RegexSplitMode$.MODULE$)).transpileToSplittableString(utf8Str.toString())) instanceof Some) {
            String simplified;
            Some some = (Some)option;
            pattern = simplified = (String)some.x();
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
            return new Some((Object)new Tuple2((Object)pattern, (Object)BoxesRunTime.boxToBoolean((boolean)isRegExp)));
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        try {
            pattern = (String)transpiler.transpile(utf8Str.toString(), (Option<String>)None$.MODULE$)._1();
            isRegExp = true;
            boxedUnit = BoxedUnit.UNIT;
        }
        catch (RegexUnsupportedException regexUnsupportedException) {
            this.willNotWorkOnGpu(regexUnsupportedException.getMessage());
            boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit2 = boxedUnit;
        return new Some((Object)new Tuple2((Object)pattern, (Object)BoxesRunTime.boxToBoolean((boolean)isRegExp)));
    }

    public Nothing$ throwUncheckedDelimiterException() {
        throw new IllegalStateException("Delimiter expression has not been checked for regex pattern");
    }

    public StringSplitRegBinaryExpMeta(INPUT expr, RapidsConf conf2, Option<RapidsMeta<?, ?>> parent, DataFromReplacementRule rule) {
        super(expr, conf2, parent, rule);
    }
}

