/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.rapids;

import com.nvidia.spark.rapids.CudfRegexTranspiler;
import com.nvidia.spark.rapids.DataFromReplacementRule;
import com.nvidia.spark.rapids.GpuOverrides$;
import com.nvidia.spark.rapids.RapidsConf;
import com.nvidia.spark.rapids.RapidsMeta;
import com.nvidia.spark.rapids.RegexSplitMode$;
import com.nvidia.spark.rapids.RegexUnsupportedException;
import com.nvidia.spark.rapids.TernaryExprMeta;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.unsafe.types.UTF8String;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001a4Q!\u0001\u0002\u0002\u00025\u0011Qc\u0015;sS:<7\u000b\u001d7jiJ+w-\u0012=q\u001b\u0016$\u0018M\u0003\u0002\u0004\t\u00051!/\u00199jINT!!\u0002\u0004\u0002\u0007M\fHN\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001)\"AD\u000e\u0014\u0005\u0001y\u0001c\u0001\t\u001835\t\u0011C\u0003\u0002\u0004%)\u0011qa\u0005\u0006\u0003)U\taA\u001c<jI&\f'\"\u0001\f\u0002\u0007\r|W.\u0003\u0002\u0019#\tyA+\u001a:oCJLX\t\u001f9s\u001b\u0016$\u0018\r\u0005\u0002\u001b71\u0001A!\u0002\u000f\u0001\u0005\u0004i\"!B%O!V#\u0016C\u0001\u0010%!\ty\"%D\u0001!\u0015\u0005\t\u0013!B:dC2\f\u0017BA\u0012!\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!\n\u0016\u000e\u0003\u0019R!a\n\u0015\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003S\u0011\t\u0001bY1uC2L8\u000f^\u0005\u0003W\u0019\u0012\u0011\u0003V3s]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o\u0011%i\u0003A!A!\u0002\u0013Ib&\u0001\u0003fqB\u0014\u0018BA\u00181\u0003\u001d9(/\u00199qK\u0012L!!M\t\u0003\u0015I\u000b\u0007/\u001b3t\u001b\u0016$\u0018\rC\u00054\u0001\t\u0005\t\u0015!\u00035o\u0005!1m\u001c8g!\t\u0001R'\u0003\u00027#\tQ!+\u00199jIN\u001cuN\u001c4\n\u0005M\u0002\u0004\"C\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001eJ\u0003\u0019\u0001\u0018M]3oiB\u0019qdO\u001f\n\u0005q\u0002#AB(qi&|g\u000eM\u0002?\u0001\u001e\u0003B\u0001\u0005\u0019@\rB\u0011!\u0004\u0011\u0003\n\u0003b\n\t\u0011!A\u0003\u0002\t\u00131a\u0018\u0013:#\tq2\t\u0005\u0002 \t&\u0011Q\t\t\u0002\u0004\u0003:L\bC\u0001\u000eH\t%A\u0005(!A\u0001\u0002\u000b\u0005!I\u0001\u0003`IE\u0002\u0014BA\u001d1\u0011!Y\u0005A!A!\u0002\u0013a\u0015\u0001\u0002:vY\u0016\u0004\"\u0001E'\n\u00059\u000b\"a\u0006#bi\u00064%o\\7SKBd\u0017mY3nK:$(+\u001e7f\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0003\u0019a\u0014N\\5u}Q)!\u000bV+W=B\u00191\u000bA\r\u000e\u0003\tAQ!L(A\u0002eAQaM(A\u0002QBQ!O(A\u0002]\u00032aH\u001eYa\rI6,\u0018\t\u0005!ARF\f\u0005\u0002\u001b7\u0012I\u0011IVA\u0001\u0002\u0003\u0015\tA\u0011\t\u00035u#\u0011\u0002\u0013,\u0002\u0002\u0003\u0005)\u0011\u0001\"\t\u000b-{\u0005\u0019\u0001'\t\u000b\u0001\u0004A\u0011A1\u0002\u0017\rDWmY6SK\u001e,\u0005\u0010\u001d\u000b\u0003EB\u00042aH\u001ed!\u0011yBMZ7\n\u0005\u0015\u0004#A\u0002+va2,'\u0007\u0005\u0002hU:\u0011q\u0004[\u0005\u0003S\u0002\na\u0001\u0015:fI\u00164\u0017BA6m\u0005\u0019\u0019FO]5oO*\u0011\u0011\u000e\t\t\u0003?9L!a\u001c\u0011\u0003\u000f\t{w\u000e\\3b]\")\u0011o\u0018a\u0001e\u0006IA-\u001a7j[\u0016C\bO\u001d\t\u0003KML!\u0001\u001e\u0014\u0003\u0015\u0015C\bO]3tg&|g\u000eC\u0003w\u0001\u0011\u0005q/\u0001\u0011uQJ|w/\u00168dQ\u0016\u001c7.\u001a3EK2LW.\u001b;fe\u0016C8-\u001a9uS>tG#\u0001\u0010")
public abstract class StringSplitRegExpMeta<INPUT extends TernaryExpression>
extends TernaryExprMeta<INPUT> {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Tuple2<String, Object>> checkRegExp(Expression delimExpr) {
        BoxedUnit boxedUnit;
        CudfRegexTranspiler transpiler;
        Option<String> option;
        String pattern = "";
        boolean isRegExp = false;
        Option<Literal> delim = GpuOverrides$.MODULE$.extractLit(delimExpr);
        if (delim.isEmpty()) {
            this.willNotWorkOnGpu("Only literal delimiter patterns are supported");
            return new Some((Object)new Tuple2((Object)pattern, (Object)BoxesRunTime.boxToBoolean((boolean)isRegExp)));
        }
        UTF8String utf8Str = (UTF8String)((Literal)delim.get()).value();
        if (utf8Str == null) {
            this.willNotWorkOnGpu("Delimiter pattern is null");
            return new Some((Object)new Tuple2((Object)pattern, (Object)BoxesRunTime.boxToBoolean((boolean)isRegExp)));
        }
        if (utf8Str.numChars() == 0) {
            this.willNotWorkOnGpu("An empty delimiter pattern is not supported");
        }
        if ((option = (transpiler = new CudfRegexTranspiler(RegexSplitMode$.MODULE$)).transpileToSplittableString(utf8Str.toString())) instanceof Some) {
            String simplified;
            Some some = (Some)option;
            pattern = simplified = (String)some.x();
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
            return new Some((Object)new Tuple2((Object)pattern, (Object)BoxesRunTime.boxToBoolean((boolean)isRegExp)));
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        try {
            pattern = (String)transpiler.transpile(utf8Str.toString(), (Option<String>)None$.MODULE$)._1();
            isRegExp = true;
            boxedUnit = BoxedUnit.UNIT;
        }
        catch (RegexUnsupportedException regexUnsupportedException) {
            this.willNotWorkOnGpu(regexUnsupportedException.getMessage());
            boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit2 = boxedUnit;
        return new Some((Object)new Tuple2((Object)pattern, (Object)BoxesRunTime.boxToBoolean((boolean)isRegExp)));
    }

    public Nothing$ throwUncheckedDelimiterException() {
        throw new IllegalStateException("Delimiter expression has not been checked for regex pattern");
    }

    public StringSplitRegExpMeta(INPUT expr, RapidsConf conf2, Option<RapidsMeta<?, ?>> parent, DataFromReplacementRule rule) {
        super(expr, conf2, parent, rule);
    }
}

