/*
 * Decompiled with CFR 0.152.
 */
package com.oath.micro.server.async.data.cleaner;

import com.google.common.eventbus.EventBus;
import com.oath.micro.server.async.data.cleaner.CleanerSchedular;
import com.oath.micro.server.async.data.cleaner.ConditionallyClean;
import com.oath.micro.server.async.data.cleaner.DataCleaner;
import com.oath.micro.server.manifest.ManifestComparator;
import cyclops.control.Maybe;
import cyclops.reactive.collections.mutable.ListX;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.function.BinaryOperator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ConfigureSchedulingAsyncDataWriter {
    @Value(value="${async.data.schedular.cron.cleaner:0 0 * * * ?}")
    private String defaultCronCleaner;
    @Value(value="${async.data.schedular.threads:1}")
    private int schedularThreads;
    @Autowired(required=false)
    private List<DataCleaner> dataCleaners = ListX.empty();
    @Autowired(required=false)
    private List<ConditionallyClean> predicates = ListX.empty();
    @Autowired
    private EventBus bus;
    @Autowired(required=false)
    private List<ManifestComparator> defaultComparators;

    private ListX<DataCleaner> dataCleaners() {
        Maybe defaultDataCleaner = this.defaultComparators.size() == 1 ? Maybe.just(new DataCleaner(this.defaultComparators.get(0), this.defaultCronCleaner)) : Maybe.nothing();
        return ListX.fromIterable((Iterable)defaultDataCleaner).plusAll(this.dataCleaners);
    }

    @Bean
    public CleanerSchedular asyncDataCleaner() {
        ConditionallyClean cc = () -> true;
        BinaryOperator accumulator = (cc1, cc2) -> () -> cc1.shouldClean() && cc2.shouldClean();
        CleanerSchedular schedular = new CleanerSchedular(this.dataCleaners(), Executors.newScheduledThreadPool(this.schedularThreads), this.bus, this.predicates.stream().reduce(cc, accumulator));
        schedular.schedule();
        return schedular;
    }
}

