/*
 * Decompiled with CFR 0.152.
 */
package com.oath.micro.server.async.data.cleaner;

import com.google.common.eventbus.EventBus;
import com.oath.micro.server.async.data.cleaner.ConditionallyClean;
import com.oath.micro.server.async.data.cleaner.DataCleaner;
import cyclops.reactive.ReactiveSeq;
import cyclops.reactive.collections.mutable.ListX;
import java.beans.ConstructorProperties;
import java.util.concurrent.ScheduledExecutorService;

public class CleanerSchedular {
    private final ListX<DataCleaner> cleaner;
    private final ScheduledExecutorService executor;
    private final EventBus bus;
    private final ConditionallyClean condition;

    public void schedule() {
        this.cleaner.forEach(cl -> ReactiveSeq.generate(() -> 1).filter(in -> this.condition.shouldClean()).map(i -> cl.scheduleAndLog()).peek(sd -> this.bus.post(sd)).schedule(cl.getCron(), this.executor));
    }

    @ConstructorProperties(value={"cleaner", "executor", "bus", "condition"})
    public CleanerSchedular(ListX<DataCleaner> cleaner, ScheduledExecutorService executor, EventBus bus, ConditionallyClean condition) {
        this.cleaner = cleaner;
        this.executor = executor;
        this.bus = bus;
        this.condition = condition;
    }
}

