/*
 * Decompiled with CFR 0.152.
 */
package com.oath.micro.server.async.data.cleaner;

import com.oath.micro.server.events.ScheduledJob;
import com.oath.micro.server.events.SystemData;
import com.oath.micro.server.manifest.ManifestComparator;
import com.oath.micro.server.utility.HashMapBuilder;
import cyclops.reactive.collections.mutable.MapX;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;

public class DataCleaner<T>
implements ScheduledJob<T> {
    public static final String MANIFEST_COMPARATOR_DATA_CLEANER_KEY = "Manifest Comparator Data Cleaner";
    private final ManifestComparator<T> comparator;
    private final String cron;
    private final Random r = new Random();

    public SystemData<String, String> scheduleAndLog() {
        String correlationId = "" + System.currentTimeMillis() + ":" + this.r.nextLong();
        Supplier<MapX> dataMap = () -> MapX.fromMap((Map)HashMapBuilder.map((Object)MANIFEST_COMPARATOR_DATA_CLEANER_KEY, (Object)this.comparator.toString()).build());
        try {
            this.comparator.cleanAll();
            return SystemData.builder().correlationId(correlationId).dataMap((Map)dataMap.get()).errors(0L).processed(1L).build();
        }
        catch (Exception e) {
            return SystemData.builder().correlationId(correlationId).dataMap((Map)dataMap.get().plus((Object)"Error", (Object)e.getMessage())).errors(1L).processed(0L).build();
        }
    }

    @ConstructorProperties(value={"comparator", "cron"})
    public DataCleaner(ManifestComparator<T> comparator, String cron) {
        this.comparator = comparator;
        this.cron = cron;
    }

    public String getCron() {
        return this.cron;
    }
}

