/*
 * Decompiled with CFR 0.152.
 */
package com.oath.micro.server.async.data.writer;

import com.google.common.eventbus.EventBus;
import com.oath.micro.server.async.data.writer.DataWriter;
import com.oath.micro.server.events.SystemData;
import com.oath.micro.server.manifest.ManifestComparator;
import com.oath.micro.server.utility.HashMapBuilder;
import cyclops.control.Future;
import cyclops.data.tuple.Tuple;
import cyclops.reactive.collections.mutable.MapX;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.function.Supplier;

public class AsyncDataWriter<T>
implements DataWriter<T> {
    public static final String MANIFEST_COMPARATOR_DATA_LOADER_KEY = "Manifest Comparator AsyncDataWriter Load Operation";
    public static final String MANIFEST_COMPARATOR_DATA_WRITER_KEY = "Manifest Comparator AsyncDataWriter Save and increment Operation";
    private final Executor executorService;
    private final ManifestComparator<T> comparator;
    private final Random r = new Random();
    private final EventBus bus;

    public static <T> AsyncDataWriter<T> asyncDataWriter(Executor executorService, ManifestComparator<T> comparator) {
        return AsyncDataWriter.asyncDataWriter(executorService, comparator, new EventBus());
    }

    public static <T> AsyncDataWriter<T> asyncDataWriter(Executor executorService, ManifestComparator<T> comparator, EventBus bus) {
        return new AsyncDataWriter<T>(executorService, comparator, bus);
    }

    @Override
    public Future<T> loadAndGet() {
        String correlationId = "" + System.currentTimeMillis() + ":" + this.r.nextLong();
        Supplier<MapX> dataMap = () -> MapX.fromMap((Map)HashMapBuilder.map((Object)MANIFEST_COMPARATOR_DATA_LOADER_KEY, (Object)this.comparator.toString()).build());
        return Future.of(() -> Tuple.tuple((Object)this.comparator.load(), (Object)this.comparator.getData()), (Executor)this.executorService).peek(t -> this.bus.post((Object)SystemData.builder().correlationId(correlationId).dataMap((Map)dataMap.get()).errors(0L).processed((Boolean)t._1() != false ? 1L : 0L).build())).map(t -> t._2());
    }

    @Override
    public Future<Void> saveAndIncrement(T data) {
        String correlationId = "" + System.currentTimeMillis() + ":" + this.r.nextLong();
        Supplier<MapX> dataMap = () -> MapX.fromMap((Map)HashMapBuilder.map((Object)MANIFEST_COMPARATOR_DATA_WRITER_KEY, (Object)this.comparator.toString()).build());
        return Future.of(() -> {
            this.comparator.saveAndIncrement(data);
            return null;
        }, (Executor)this.executorService).peek(t -> this.bus.post((Object)SystemData.builder().correlationId(correlationId).dataMap((Map)dataMap.get()).errors(0L).processed(1L).build()));
    }

    @Override
    public Future<Boolean> isOutOfDate() {
        return Future.of(() -> this.comparator.isOutOfDate(), (Executor)this.executorService);
    }

    @ConstructorProperties(value={"executorService", "comparator", "bus"})
    public AsyncDataWriter(Executor executorService, ManifestComparator<T> comparator, EventBus bus) {
        this.executorService = executorService;
        this.comparator = comparator;
        this.bus = bus;
    }
}

