/*
 * Decompiled with CFR 0.152.
 */
package com.oath.micro.server.async.data.writer;

import com.google.common.eventbus.EventBus;
import com.oath.micro.server.async.data.writer.AsyncDataWriter;
import com.oath.micro.server.async.data.writer.MultiDataWriter;
import com.oath.micro.server.manifest.ManifestComparator;
import cyclops.reactive.collections.mutable.ListX;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ConfigureDataWriter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired(required=false)
    private List<ManifestComparator> defaultComparators = ListX.empty();
    @Value(value="${async.data.writer.threads:1}")
    private int writerThreads = 1;
    @Value(value="${async.data.writer.multi:false}")
    private boolean multiWriterOn = false;
    @Autowired
    private EventBus bus;

    @Bean
    public AsyncDataWriter<?> defaultDataWriter() {
        if (this.defaultComparators.size() > 0) {
            System.err.println("Warning :: multiple ManifestComparators configured as Spring bean, using the first configured bean for the Default AsyncDataWriter, recommended approach is to configure your own DataWriters as needed.");
            this.logger.warn("Warning :: multiple ManifestComparators configured as Spring bean, using the first configured bean for the Default AsyncDataWriter, recommended approach is to configure your own DataWriters as needed.");
        }
        return new AsyncDataWriter(this.asyncDataWriterThreadPool(), this.defaultComparators.get(0), this.bus);
    }

    @Bean
    public MultiDataWriter<?> defaultMultiDataWriter() {
        if (this.multiWriterOn) {
            return new MultiDataWriter(ListX.fromIterable(this.defaultComparators).map(mc -> new AsyncDataWriter(this.asyncDataWriterThreadPool(), mc, this.bus)));
        }
        return new MultiDataWriter(ListX.empty());
    }

    @Bean
    public Executor asyncDataWriterThreadPool() {
        return Executors.newFixedThreadPool(this.writerThreads);
    }
}

