/*
 * Decompiled with CFR 0.152.
 */
package com.oath.micros.server.elasticache;

import com.oath.micro.server.elasticache.TransientElasticacheDataConnection;
import java.util.Optional;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.internal.OperationFuture;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TransientElasticacheDataConnectionTest {
    MemcachedClient memcachedClient;

    @Before
    public void setup() {
        this.memcachedClient = (MemcachedClient)Mockito.mock(MemcachedClient.class);
        Mockito.stub((Object)this.memcachedClient.get("key1")).toReturn((Object)"value1");
        Mockito.stub((Object)this.memcachedClient.get("key2")).toReturn((Object)"value2");
        OperationFuture mockedFuture = (OperationFuture)Mockito.mock(OperationFuture.class);
        Mockito.stub((Object)this.memcachedClient.add("keyAdd", 3600, (Object)"valueadd")).toReturn((Object)mockedFuture);
    }

    @Test
    public void happyPathGetTest() {
        TransientElasticacheDataConnection transientClient = new TransientElasticacheDataConnection(this.memcachedClient, 3, 1);
        Assert.assertEquals(Optional.ofNullable("value1"), (Object)transientClient.get("key1"));
        Assert.assertEquals(Optional.ofNullable("value2"), (Object)transientClient.get("key2"));
    }

    @Test
    public void notExistingKeyGetTest() {
        TransientElasticacheDataConnection transientClient = new TransientElasticacheDataConnection(this.memcachedClient, 3, 1);
        Assert.assertEquals(Optional.empty(), (Object)transientClient.get("key3"));
    }

    @Test
    public void notExistingKeyPutTest() {
        TransientElasticacheDataConnection transientClient = new TransientElasticacheDataConnection(this.memcachedClient, 3, 1);
        Assert.assertEquals((Object)false, (Object)transientClient.add("keyAdd", 3600, (Object)"valueadd"));
    }

    @Test
    public void testIsAvailableFalse() {
        TransientElasticacheDataConnection transientClient = new TransientElasticacheDataConnection(this.memcachedClient, 3, 1);
        transientClient.setConnectionTested(false);
        Assert.assertEquals((Object)false, (Object)transientClient.isAvailable());
    }

    @Test
    public void testIsAvailableTrue() {
        TransientElasticacheDataConnection transientClient = new TransientElasticacheDataConnection(this.memcachedClient, 3, 1);
        transientClient.setConnectionTested(true);
        Assert.assertEquals((Object)true, (Object)transientClient.isAvailable());
    }
}

