/*
 * Decompiled with CFR 0.152.
 */
package app.event.metrics.com.oath.micro.server;

import com.oath.micro.server.MicroserverApp;
import com.oath.micro.server.config.Microserver;
import com.oath.micro.server.module.Module;
import com.oath.micro.server.rest.jackson.JacksonUtil;
import com.oath.micro.server.testing.RestAgent;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@Microserver
public class EventRunnerTest {
    RestAgent rest = new RestAgent();
    MicroserverApp server;

    @Before
    public void startServer() {
        this.server = new MicroserverApp(new Module[]{() -> "event-app"});
        this.server.start();
    }

    @After
    public void stopServer() {
        this.server.stop();
    }

    @Test
    public void runAppAndBasicTest() throws InterruptedException, ExecutionException {
        Assert.assertThat((Object)this.rest.get("http://localhost:8080/event-app/status/ping"), (Matcher)Matchers.is((Object)"ok"));
        Assert.assertThat((Object)this.rest.getJson("http://localhost:8080/event-app/active/jobs"), (Matcher)Matchers.containsString((String)"startedAt"));
        Assert.assertThat((Object)this.rest.getJson("http://localhost:8080/event-app/active/requests"), (Matcher)Matchers.containsString((String)"startedAt"));
        Assert.assertThat((Object)this.rest.getJson("http://localhost:8080/event-app/manifest"), (Matcher)Matchers.containsString((String)"Manifest"));
        String json = this.rest.getJson("http://localhost:8080/event-app/status/counters");
        Map map = (Map)JacksonUtil.convertFromJson((String)json, Map.class);
        Assert.assertThat((String)json, map.get("com.oath.micro.server.event.metrics.MetricsCatcher.jobs-completed-count"), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(1)));
        String json2 = this.rest.getJson("http://localhost:8080/event-app/status/meters");
        Map map2 = (Map)JacksonUtil.convertFromJson((String)json2, Map.class);
        Assert.assertThat((String)json2, map2.get("com.oath.micro.server.event.metrics.MetricsCatcher.request-start-default-meter"), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }
}

