/*
 * Decompiled with CFR 0.152.
 */
package app.event.metrics.com.oath.micro.server;

import com.codahale.metrics.MetricRegistry;
import com.google.common.eventbus.EventBus;
import com.oath.micro.server.auto.discovery.RestResource;
import com.oath.micro.server.events.RequestEvents;
import cyclops.reactive.collections.mutable.MapX;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="/status")
public class EventStatusResource
implements RestResource {
    private final EventBus bus;
    private final MetricRegistry metrics;

    @Autowired
    public EventStatusResource(EventBus bus, MetricRegistry metrics) {
        this.bus = bus;
        this.metrics = metrics;
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="/ping")
    public String ping() {
        this.bus.post((Object)RequestEvents.start((Object)"get", (long)1L));
        try {
            String string = "ok";
            return string;
        }
        finally {
            this.bus.post((Object)RequestEvents.finish((Object)"get", (long)1L));
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/counters")
    public Map<String, Long> counters() {
        return MapX.fromMap((Map)this.metrics.getCounters()).bimap(k -> k, v -> v.getCount());
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/meters")
    public Map<String, Long> meters() {
        return MapX.fromMap((Map)this.metrics.getMeters()).bimap(k -> k, v -> v.getCount());
    }
}

