/*
 * Decompiled with CFR 0.152.
 */
package com.oath.micro.server.event.metrics;

import com.codahale.metrics.MetricRegistry;
import com.google.common.eventbus.EventBus;
import com.oath.micro.server.errors.ErrorCode;
import com.oath.micro.server.event.metrics.Configuration;
import com.oath.micro.server.event.metrics.MetricsCatcher;
import com.oath.micro.server.events.JobCompleteEvent;
import com.oath.micro.server.events.JobStartEvent;
import com.oath.micro.server.events.RequestTypes;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MetricsCatcherConfigOffTest {
    MetricsCatcher<?> catcher;
    MetricRegistry registry;
    EventBus bus;
    Configuration config;

    @Before
    public void setup() {
        this.registry = new MetricRegistry();
        this.bus = new EventBus();
        this.config = new Configuration(false, false, false, false, 5, 6, 7, 8, 10, "bob");
        this.catcher = new MetricsCatcher(this.registry, this.bus, this.config);
    }

    @Test
    public void queriesStartMeterInc() {
        this.catcher.requestStart(new RequestTypes.AddQuery(RequestTypes.RequestData.builder().correlationId(10L).type("test").build()));
        Assert.assertThat((Object)this.registry.meter(this.config.getPrefix() + ".request-start-test").getMeanRate(), (Matcher)Matchers.equalTo((Object)0.0));
    }

    @Test
    public void queriesEndMeterInc() {
        this.catcher.requestComplete(new RequestTypes.RemoveQuery(RequestTypes.RequestData.builder().correlationId(10L).type("test").build()));
        Assert.assertThat((Object)this.registry.meter(this.config.getPrefix() + ".request-end-test").getMeanRate(), (Matcher)Matchers.equalTo((Object)0.0));
    }

    @Test
    public void queriesCounterInc() {
        this.catcher.requestStart(new RequestTypes.AddQuery(RequestTypes.RequestData.builder().correlationId(10L).type("test").build()));
        Assert.assertThat((Object)this.registry.counter(this.config.getPrefix() + ".requests-active-test-count").getCount(), (Matcher)Matchers.equalTo((Object)0L));
    }

    @Test
    public void queriesCounterDec() {
        this.catcher.requestComplete(new RequestTypes.RemoveQuery(RequestTypes.RequestData.builder().correlationId(10L).type("test").build()));
        Assert.assertThat((Object)this.registry.counter(this.config.getPrefix() + ".requests-active-test-count").getCount(), (Matcher)Matchers.equalTo((Object)0L));
    }

    @Test
    public void jobsCounterDec() {
        this.catcher.jobComplete(new JobCompleteEvent(10L, "test", 10L, 5L));
        Assert.assertThat((Object)this.registry.counter(this.config.getPrefix() + ".jobs-active-test-count").getCount(), (Matcher)Matchers.equalTo((Object)0L));
    }

    @Test
    public void queriesTimer() {
        this.catcher.requestStart(new RequestTypes.AddQuery(RequestTypes.RequestData.builder().correlationId(10L).type("test").build()));
        this.catcher.requestComplete(new RequestTypes.RemoveQuery(RequestTypes.RequestData.builder().correlationId(10L).type("test").build()));
        Assert.assertThat((Object)this.registry.timer(this.config.getPrefix() + ".request-end-test-timer").getMeanRate(), (Matcher)Matchers.equalTo((Object)0.0));
    }

    @Test
    public void jobsMeterInc() {
        this.catcher.jobStarted(new JobStartEvent(10L, "test"));
        Assert.assertThat((Object)this.registry.meter(this.config.getPrefix() + ".job-meter-test").getMeanRate(), (Matcher)Matchers.equalTo((Object)0.0));
    }

    @Test
    public void jobsCounterInc() {
        this.catcher.jobStarted(new JobStartEvent(10L, "test"));
        Assert.assertThat((Object)this.registry.counter(this.config.getPrefix() + ".jobs-active-test-count").getCount(), (Matcher)Matchers.equalTo((Object)0L));
    }

    @Test
    public void testErrorCount() {
        this.catcher.error(ErrorCode.medium((int)10, (String)"hello world"));
        Assert.assertThat((Object)this.registry.counter(this.config.getPrefix() + ".error-MEDIUM-10-count").getCount(), (Matcher)Matchers.equalTo((Object)0L));
    }

    @Test
    public void testErrorMeter() {
        this.catcher.error(ErrorCode.medium((int)10, (String)"hello world"));
        Assert.assertThat((Object)this.registry.meter(this.config.getPrefix() + ".error-MEDIUM-10").getMeanRate(), (Matcher)Matchers.equalTo((Object)0.0));
    }

    @Test
    public void testSeverityErrorCount() {
        this.catcher.error(ErrorCode.medium((int)10, (String)"hello world"));
        Assert.assertThat((Object)this.registry.counter(this.config.getPrefix() + ".error-severity-MEDIUM-count").getCount(), (Matcher)Matchers.equalTo((Object)0L));
    }

    @Test
    public void testErrorSeverityMeter() {
        this.catcher.error(ErrorCode.medium((int)10, (String)"hello world"));
        Assert.assertThat((Object)this.registry.meter(this.config.getPrefix() + ".error-severity-MEDIUM").getMeanRate(), (Matcher)Matchers.equalTo((Object)0.0));
    }
}

