/*
 * Decompiled with CFR 0.152.
 */
package com.oath.micro.server.event.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricRegistry;
import com.google.common.eventbus.EventBus;
import com.oath.micro.server.errors.ErrorCode;
import com.oath.micro.server.event.metrics.Configuration;
import com.oath.micro.server.event.metrics.MetricsCatcher;
import com.oath.micro.server.events.GenericEvent;
import com.oath.micro.server.events.JobCompleteEvent;
import com.oath.micro.server.events.JobStartEvent;
import com.oath.micro.server.events.RequestTypes;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MetricsCatcherTest {
    MetricsCatcher<?> catcher;
    MetricRegistry registry;
    EventBus bus;
    Configuration config;

    @Before
    public void setup() {
        this.registry = new MetricRegistry();
        this.bus = new EventBus();
        this.config = new Configuration(true, true, true, true, 5, 6, 7, 8, 10, "bob");
        this.catcher = new MetricsCatcher(this.registry, this.bus, this.config);
    }

    @Test
    public void queriesStartMeterInc() {
        this.catcher.requestStart(new RequestTypes.AddQuery(RequestTypes.RequestData.builder().correlationId(10L).type("test").build()));
        Assert.assertThat((Object)this.registry.meter(this.config.getPrefix() + ".request-start-test-meter").getMeanRate(), (Matcher)Matchers.greaterThan((Comparable)Double.valueOf(0.0)));
    }

    @Test
    public void queriesEndMeterInc() {
        this.catcher.requestComplete(new RequestTypes.RemoveQuery(RequestTypes.RequestData.builder().correlationId(10L).type("test").build()));
        Assert.assertThat((Object)this.registry.meter(this.config.getPrefix() + ".request-end-test").getMeanRate(), (Matcher)Matchers.greaterThan((Comparable)Double.valueOf(0.0)));
    }

    @Test
    public void queriesCounterInc() {
        this.catcher.requestStart(new RequestTypes.AddQuery(RequestTypes.RequestData.builder().correlationId(10L).type("test").build()));
        Assert.assertThat((Object)this.registry.counter(this.config.getPrefix() + ".requests-active-test-count").getCount(), (Matcher)Matchers.equalTo((Object)1L));
    }

    @Test
    public void queriesCounterDec() {
        this.catcher.requestComplete(new RequestTypes.RemoveQuery(RequestTypes.RequestData.builder().correlationId(10L).type("test").build()));
        Assert.assertThat((Object)this.registry.counter(this.config.getPrefix() + ".requests-active-test-count").getCount(), (Matcher)Matchers.equalTo((Object)-1L));
    }

    @Test
    public void queriesIntervalCounterInc() {
        this.catcher.requestStart(new RequestTypes.AddQuery(RequestTypes.RequestData.builder().correlationId(10L).type("test").build()));
        Assert.assertThat((Object)this.registry.getGauges().size(), (Matcher)Matchers.equalTo((Object)2));
        Assert.assertThat((Object)((Gauge)this.registry.getGauges().get(this.config.getPrefix() + ".requests-started-interval-count")).getValue(), (Matcher)Matchers.equalTo((Object)1L));
        Assert.assertThat((Object)((Gauge)this.registry.getGauges().get(this.config.getPrefix() + ".requests-started-test-interval-count")).getValue(), (Matcher)Matchers.equalTo((Object)1L));
    }

    @Test
    public void queriesIntervalCounterDec() {
        this.catcher.requestComplete(new RequestTypes.RemoveQuery(RequestTypes.RequestData.builder().correlationId(10L).type("test").build()));
        Assert.assertThat((Object)this.registry.getGauges().size(), (Matcher)Matchers.equalTo((Object)2));
        Assert.assertThat((Object)((Gauge)this.registry.getGauges().get(this.config.getPrefix() + ".requests-completed-interval-count")).getValue(), (Matcher)Matchers.equalTo((Object)1L));
        Assert.assertThat((Object)((Gauge)this.registry.getGauges().get(this.config.getPrefix() + ".requests-completed-test-interval-count")).getValue(), (Matcher)Matchers.equalTo((Object)1L));
    }

    @Test
    public void jobsCounterDec() {
        this.catcher.jobComplete(new JobCompleteEvent(10L, "test", 10L, 5L));
        Assert.assertThat((Object)this.registry.counter(this.config.getPrefix() + ".jobs-active-test-count").getCount(), (Matcher)Matchers.equalTo((Object)-1L));
    }

    @Test
    public void queriesTimer() {
        this.catcher.requestStart(new RequestTypes.AddQuery(RequestTypes.RequestData.builder().correlationId(10L).type("test").build()));
        this.catcher.requestComplete(new RequestTypes.RemoveQuery(RequestTypes.RequestData.builder().correlationId(10L).type("test").build()));
        Assert.assertThat((Object)this.registry.timer(this.config.getPrefix() + ".request-end-test-timer").getMeanRate(), (Matcher)Matchers.greaterThan((Comparable)Double.valueOf(0.0)));
    }

    @Test
    public void jobsMeterInc() {
        this.catcher.jobStarted(new JobStartEvent(10L, "test"));
        Assert.assertThat((Object)this.registry.meter(this.config.getPrefix() + ".job-meter-test").getMeanRate(), (Matcher)Matchers.greaterThan((Comparable)Double.valueOf(0.0)));
    }

    @Test
    public void jobsCounterInc() {
        this.catcher.jobStarted(new JobStartEvent(10L, "test"));
        Assert.assertThat((Object)this.registry.counter(this.config.getPrefix() + ".jobs-active-test-count").getCount(), (Matcher)Matchers.equalTo((Object)1L));
    }

    @Test
    public void testErrorCount() {
        this.catcher.error(ErrorCode.medium((int)10, (String)"hello world"));
        Assert.assertThat((Object)this.registry.counter(this.config.getPrefix() + ".error-MEDIUM-10-count").getCount(), (Matcher)Matchers.equalTo((Object)1L));
    }

    @Test
    public void testErrorMeter() {
        this.catcher.error(ErrorCode.medium((int)10, (String)"hello world"));
        Assert.assertThat((Object)this.registry.meter(this.config.getPrefix() + ".error-MEDIUM-10").getMeanRate(), (Matcher)Matchers.greaterThan((Comparable)Double.valueOf(0.0)));
    }

    @Test
    public void testSeverityErrorCount() {
        this.catcher.error(ErrorCode.medium((int)10, (String)"hello world"));
        Assert.assertThat((Object)this.registry.counter(this.config.getPrefix() + ".error-severity-MEDIUM-count").getCount(), (Matcher)Matchers.equalTo((Object)1L));
    }

    @Test
    public void testErrorSeverityMeter() {
        this.catcher.error(ErrorCode.medium((int)10, (String)"hello world"));
        Assert.assertThat((Object)this.registry.meter(this.config.getPrefix() + ".error-severity-MEDIUM").getMeanRate(), (Matcher)Matchers.greaterThan((Comparable)Double.valueOf(0.0)));
    }

    @Test
    public void testGenericEvent() {
        GenericEvent.trigger((String)"generic", (EventBus)this.bus, (Object)"data", (String[])new String[]{"p1", "p2"});
        Assert.assertThat((Object)this.registry.meter(this.config.getPrefix() + ".event-generic-meter").getCount(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        Assert.assertThat((Object)this.registry.counter(this.config.getPrefix() + ".event-generic-count").getCount(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        Assert.assertThat((Object)this.registry.meter(this.config.getPrefix() + ".event-generic.p1-meter").getCount(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        Assert.assertThat((Object)this.registry.counter(this.config.getPrefix() + ".event-generic.p1-count").getCount(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        Assert.assertThat((Object)this.registry.meter(this.config.getPrefix() + ".event-generic.p1.p2-meter").getCount(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        Assert.assertThat((Object)this.registry.counter(this.config.getPrefix() + ".event-generic.p1.p2-count").getCount(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
    }
}

