/*
 * Decompiled with CFR 0.152.
 */
package com.oath.micro.server.general.exception.mapper;

import com.oath.micro.server.general.exception.mapper.ExceptionWrapper;
import com.oath.micro.server.general.exception.mapper.MapOfExceptionsToErrorCodes;
import cyclops.data.tuple.Tuple;
import cyclops.data.tuple.Tuple2;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@Provider
public class GeneralExceptionMapper
implements ExceptionMapper<Exception> {
    final Logger logger;
    private Boolean showDetails;
    Map<Class<? extends Exception>, Tuple2<String, Response.Status>> mapOfExceptionsToErrorCodes = MapOfExceptionsToErrorCodes.getMergedMappings();

    GeneralExceptionMapper(Logger logger, boolean showDetails) {
        this.logger = logger;
        this.showDetails = showDetails;
    }

    @Autowired
    GeneralExceptionMapper(@Value(value="${micro.general.exception.mapper.details:true}") Boolean showDetails) {
        this(LoggerFactory.getLogger(GeneralExceptionMapper.class), showDetails);
    }

    private Optional<Tuple2<String, Response.Status>> find(Class<? extends Exception> c) {
        for (Map.Entry<Class<? extends Exception>, Tuple2<String, Response.Status>> entry : this.mapOfExceptionsToErrorCodes.entrySet()) {
            if (!entry.getKey().isAssignableFrom(c)) continue;
            return Optional.ofNullable(entry.getValue());
        }
        return Optional.empty();
    }

    public Response toResponse(Exception ex) {
        String errorTrackingId = UUID.randomUUID().toString();
        Tuple2 error = new Tuple2((Object)"INTERNAL_SERVER_ERROR", (Object)Response.Status.INTERNAL_SERVER_ERROR);
        Optional<Tuple2<String, Response.Status>> errorFromLookup = this.find(ex.getClass());
        if (errorFromLookup.isPresent()) {
            error = errorFromLookup.get();
        } else if (ex instanceof WebApplicationException) {
            WebApplicationException rsEx = (WebApplicationException)ex;
            error = Tuple.tuple((Object)rsEx.getResponse().getStatusInfo().getReasonPhrase(), (Object)Response.Status.fromStatusCode((int)rsEx.getResponse().getStatus()));
        }
        this.logger.error(String.format("%s Error id: %s, %s", error._1(), errorTrackingId, ex.getMessage()), (Throwable)ex);
        Response.ResponseBuilder responseBuilder = Response.status((Response.Status)((Response.Status)error._2())).type(MediaType.APPLICATION_JSON_TYPE);
        if (this.showDetails.booleanValue()) {
            responseBuilder.entity((Object)new ExceptionWrapper((String)error._1(), String.format("Error id: %s %s", errorTrackingId, ex.getMessage())));
        } else {
            responseBuilder.entity((Object)new ExceptionWrapper("INTERNAL_SERVER_ERROR", errorTrackingId));
        }
        return responseBuilder.build();
    }
}

