/*
 * Decompiled with CFR 0.152.
 */
package com.oath.micro.server.log;

import com.oath.micro.server.log.LogLookup;
import java.io.File;
import java.util.Optional;
import org.apache.commons.io.input.Tailer;
import org.apache.commons.io.input.TailerListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class LogTailer {
    private final String fileLocation;
    private final Optional<LogLookup> logLookup;

    @Autowired(required=false)
    public LogTailer(@Value(value="${log.tailer.file.location:}") String fileLocation) {
        this.fileLocation = fileLocation;
        this.logLookup = Optional.empty();
    }

    @Autowired(required=false)
    public LogTailer(@Value(value="${log.tailer.file.location:}") String fileLocation, LogLookup logLookup) {
        this.fileLocation = fileLocation;
        this.logLookup = Optional.of(logLookup);
    }

    public void tail(TailerListener listener) {
        File file = new File(this.fileLocation);
        Tailer tailer = Tailer.create((File)file, (TailerListener)listener, (long)10L);
        tailer.run();
    }

    public void tail(TailerListener listener, String alias) {
        File file = this.logLookup.map(l -> l.lookup(alias)).orElse(new File(this.fileLocation));
        Tailer tailer = Tailer.create((File)file, (TailerListener)listener, (long)10L);
        tailer.run();
    }
}

