/*
 * Decompiled with CFR 0.152.
 */
package com.oath.micro.server.log.rest;

import com.oath.micro.server.auto.discovery.CommonRestResource;
import com.oath.micro.server.auto.discovery.SingletonRestResource;
import com.oath.micro.server.log.LogTailer;
import java.beans.ConstructorProperties;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.io.input.Tailer;
import org.apache.commons.io.input.TailerListener;
import org.springframework.stereotype.Component;

@Path(value="/log-tail")
@Component
public class LogStreamer
implements CommonRestResource,
SingletonRestResource {
    private final LogTailer tailer;

    public LogStreamer(LogTailer tailer) {
        this.tailer = tailer;
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="/stream-file")
    public Response streamTarget(final @QueryParam(value="alias") String alias) {
        StreamingOutput stream = new StreamingOutput(){

            public void write(OutputStream os) throws IOException, WebApplicationException {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os));
                LogListener listener = new LogListener((Writer)writer);
                LogStreamer.this.tailer.tail(listener, alias);
            }
        };
        return Response.ok((Object)stream).build();
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="/stream")
    public Response stream() {
        StreamingOutput stream = new StreamingOutput(){

            public void write(OutputStream os) throws IOException, WebApplicationException {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os));
                LogListener listener = new LogListener((Writer)writer);
                LogStreamer.this.tailer.tail(listener);
            }
        };
        return Response.ok((Object)stream).build();
    }

    static class LogListener
    implements TailerListener {
        private final Writer writer;
        private volatile Tailer tailer;

        public void init(Tailer tailer) {
            this.tailer = tailer;
        }

        public void fileNotFound() {
            try {
                this.writer.write("File not found!");
                this.writer.flush();
            }
            catch (IOException e) {
                this.tailer.stop();
            }
        }

        public void fileRotated() {
            try {
                this.writer.flush();
            }
            catch (IOException e) {
                this.tailer.stop();
            }
        }

        public void handle(String line) {
            try {
                System.out.println("Writing :" + line);
                this.writer.write(line);
                this.writer.write("\n");
            }
            catch (IOException e) {
                this.tailer.stop();
            }
        }

        public void handle(Exception ex) {
            try {
                this.writer.write("Error " + ex.getMessage());
                this.writer.write("/n");
                this.writer.flush();
            }
            catch (IOException e) {
                this.tailer.stop();
            }
        }

        private LogListener(Writer writer) {
            this.writer = writer;
            this.tailer = null;
        }

        @ConstructorProperties(value={"writer", "tailer"})
        public LogListener(Writer writer, Tailer tailer) {
            this.writer = writer;
            this.tailer = tailer;
        }
    }
}

