/*
 * Decompiled with CFR 0.152.
 */
package com.oath.micro.server.datadog.metrics;

import com.oath.micro.server.datadog.metrics.DatadogMetricsConfigurer;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import org.coursera.metrics.datadog.DatadogReporter;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class DatadogMetricsConfigurerTest {
    private String apiKey = "api";
    private String tags = "tags";
    private int period = 10;
    private TimeUnit timeUnit = TimeUnit.DAYS;

    @Test
    public void expansionsDefault() {
        String expStr = null;
        DatadogMetricsConfigurer c = new DatadogMetricsConfigurer(this.apiKey, this.tags, this.period, this.timeUnit, expStr, null);
        Assert.assertThat((Object)c.getExpansions(), (Matcher)Matchers.equalTo((Object)DatadogReporter.Expansion.ALL));
    }

    @Test
    public void expansionsSingle() {
        String expStr = DatadogReporter.Expansion.MEDIAN.name();
        DatadogMetricsConfigurer c = new DatadogMetricsConfigurer(this.apiKey, this.tags, this.period, this.timeUnit, expStr, null);
        Assert.assertThat((Object)c.getExpansions(), (Matcher)Matchers.equalTo(EnumSet.of(DatadogReporter.Expansion.MEDIAN)));
    }

    @Test
    public void expansionsTwo() {
        String expStr = DatadogReporter.Expansion.MEDIAN.name() + "," + DatadogReporter.Expansion.RATE_15_MINUTE.name();
        DatadogMetricsConfigurer c = new DatadogMetricsConfigurer(this.apiKey, this.tags, this.period, this.timeUnit, expStr, null);
        Assert.assertThat((Object)c.getExpansions(), (Matcher)Matchers.equalTo(EnumSet.of(DatadogReporter.Expansion.MEDIAN, DatadogReporter.Expansion.RATE_15_MINUTE)));
    }

    @Test
    public void expansionsTwoSpace() {
        String expStr = DatadogReporter.Expansion.MEDIAN.name() + " , " + DatadogReporter.Expansion.RATE_15_MINUTE.name();
        DatadogMetricsConfigurer c = new DatadogMetricsConfigurer(this.apiKey, this.tags, this.period, this.timeUnit, expStr, null);
        Assert.assertThat((Object)c.getExpansions(), (Matcher)Matchers.equalTo(EnumSet.of(DatadogReporter.Expansion.MEDIAN, DatadogReporter.Expansion.RATE_15_MINUTE)));
    }
}

