/*
 * Decompiled with CFR 0.152.
 */
package com.oath.micro.server.datadog.metrics;

import com.codahale.metrics.MetricRegistry;
import com.ryantenney.metrics.spring.config.annotation.EnableMetrics;
import com.ryantenney.metrics.spring.config.annotation.MetricsConfigurerAdapter;
import cyclops.control.Maybe;
import java.io.Closeable;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.coursera.metrics.datadog.DatadogReporter;
import org.coursera.metrics.datadog.transport.HttpTransport;
import org.coursera.metrics.datadog.transport.Transport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableMetrics
public class DatadogMetricsConfigurer
extends MetricsConfigurerAdapter {
    private static final Logger log = LoggerFactory.getLogger(DatadogMetricsConfigurer.class);
    private String apiKey;
    private List<String> tags;
    private int period;
    private TimeUnit timeUnit;
    private EnumSet<DatadogReporter.Expansion> expansions;
    private final String host;

    @Autowired
    public DatadogMetricsConfigurer(@Value(value="${datadog.apikey:#{null}}") String apiKey, @Value(value="${datadog.tags:{\"stage:dev\"}}") String tags, @Value(value="${datadog.report.period:1}") int period, @Value(value="${datadog.report.timeunit:SECONDS}") TimeUnit timeUnit, @Value(value="${datadog.report.expansions:#{null}}") String expStr, @Value(value="${host.address:#{null}}") String host) {
        this.apiKey = apiKey;
        this.tags = Arrays.asList(Optional.ofNullable(tags).orElse("").split(","));
        this.period = period;
        this.timeUnit = timeUnit;
        this.expansions = this.expansions(expStr);
        this.host = host;
    }

    private EnumSet<DatadogReporter.Expansion> expansions(String expStr) {
        return (EnumSet)Maybe.just((Object)Maybe.ofNullable((Object)expStr).map(s -> s.split(",")).stream().flatMap(Stream::of).map(String::trim).map(DatadogReporter.Expansion::valueOf).collect(Collectors.toCollection(() -> EnumSet.noneOf(DatadogReporter.Expansion.class)))).filter(s -> !s.isEmpty()).orElse((Object)DatadogReporter.Expansion.ALL);
    }

    public void configureReporters(MetricRegistry metricRegistry) {
        if (Objects.isNull(this.apiKey)) {
            log.error("The 'datadog.apikey' is null. Datadog reporting will be ignored.");
            return;
        }
        HttpTransport httpTransport = new HttpTransport.Builder().withApiKey(this.apiKey).build();
        EnumSet expansions = DatadogReporter.Expansion.ALL;
        DatadogReporter.Builder builder = DatadogReporter.forRegistry((MetricRegistry)metricRegistry).withTransport((Transport)httpTransport).withExpansions(expansions).withTags(this.tags);
        DatadogReporter reporter = (Objects.nonNull(this.host) ? builder.withHost(this.host) : builder).build();
        reporter.start((long)this.period, this.timeUnit);
        this.registerReporter((Closeable)reporter);
    }

    public EnumSet<DatadogReporter.Expansion> getExpansions() {
        return this.expansions;
    }
}

