/*
 * Decompiled with CFR 0.152.
 */
package app.streaming.com.aol.micro.server;

import com.oath.micro.server.MicroserverApp;
import com.oath.micro.server.auto.discovery.RestResource;
import com.oath.micro.server.config.Microserver;
import com.oath.micro.server.module.Module;
import com.oath.micro.server.reactive.rest.ReactiveRequest;
import com.oath.micro.server.reactive.rest.ReactiveResponse;
import com.oath.micro.server.testing.RestAgent;
import cyclops.reactive.ReactiveSeq;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.reactivestreams.Publisher;

@Microserver
@Path(value="/single")
public class SingleClassTest
implements RestResource {
    RestAgent rest = new RestAgent();
    MicroserverApp server;
    static String lastRecieved = null;

    @Before
    public void startServer() {
        lastRecieved = null;
        this.server = new MicroserverApp(SingleClassTest.class, new Module[]{() -> "simple-app"});
        this.server.start();
    }

    @After
    public void stopServer() {
        this.server.stop();
    }

    @Test
    public void runAppAndBasicTest() throws InterruptedException, ExecutionException {
        List boos = new ReactiveRequest(1000, 1000).getJsonStream("http://localhost:8080/simple-app/single/infinite-boo", String.class).toList();
        Assert.assertThat((Object)boos.size(), (Matcher)CoreMatchers.is((Object)5));
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="/example")
    public Response streamExample() {
        StreamingOutput stream = new StreamingOutput(){

            public void write(OutputStream os) throws IOException, WebApplicationException {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os));
                for (int i = 0; i < 100000000; ++i) {
                    writer.write("test");
                    ((Writer)writer).flush();
                }
            }
        };
        return Response.ok((Object)stream).build();
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="/out")
    public Response output() {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < 100000; ++i) {
            b.append("test");
        }
        return Response.ok((Object)b.toString()).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/infinite-boo")
    public Response boo() {
        Response response = ReactiveResponse.publishAsJson((Publisher)ReactiveSeq.generate(() -> "boo!").limit(5L));
        System.out.println("created response");
        return response;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/ping")
    public Response ping() {
        Response response = ReactiveResponse.publishAsJson((Publisher)ReactiveSeq.of((Object[])new Integer[]{1, 2, 3, 4}).limit(5L));
        System.out.println("created response");
        return response;
    }
}

