/*
 * Decompiled with CFR 0.152.
 */
package com.oath.micro.server.reactive;

import com.oath.micro.server.events.ScheduledJob;
import com.oath.micro.server.events.SystemData;
import com.oath.micro.server.reactive.JobSchedular;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class ScheduledJobTest {
    ScheduledExecutorService ex = Executors.newScheduledThreadPool(1);
    JobSchedular executor = new JobSchedular(this.ex);
    AtomicInteger count = new AtomicInteger(0);
    ScheduledJob<ScheduledJobTest> myJob = new ScheduledJob<ScheduledJobTest>(){

        public SystemData<String, String> scheduleAndLog() {
            ScheduledJobTest.this.count.incrementAndGet();
            return SystemData.builder().build();
        }
    };

    public void saveRecord(Object o) {
    }

    @Test
    public void cronDebounceTest() throws InterruptedException {
        Assert.assertThat((Object)this.executor.schedule("* * * * * ?", this.myJob).connect().limit(4L).debounce(1L, TimeUnit.DAYS).peek(System.out::println).toList().size(), (Matcher)Matchers.equalTo((Object)1));
    }

    @Test
    public void fixedRateTest() throws InterruptedException {
        Assert.assertThat((Object)this.executor.scheduleFixedRate(100L, this.myJob).connect().limit(4L).debounce(1L, TimeUnit.DAYS).peek(System.out::println).toList().size(), (Matcher)Matchers.equalTo((Object)1));
    }

    @Test
    public void fixedRateDelay() throws InterruptedException {
        Assert.assertThat((Object)this.executor.scheduleFixedDelay(1000L, this.myJob).connect().limit(4L).debounce(1L, TimeUnit.DAYS).peek(System.out::println).toList().size(), (Matcher)Matchers.equalTo((Object)1));
    }
}

