/*
 * Decompiled with CFR 0.152.
 */
package com.oath.micro.server.rest.jersey;

import com.oath.micro.server.GlobalState;
import com.oath.micro.server.auto.discovery.Rest;
import com.oath.micro.server.auto.discovery.RestResource;
import com.oath.micro.server.module.JaxRsProvider;
import com.oath.micro.server.module.Module;
import com.oath.micro.server.module.ModuleDataExtractor;
import cyclops.collections.immutable.LinkedListX;
import java.util.Map;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.server.ResourceConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class SpringBootJerseyRestApplication
extends ResourceConfig {
    @Autowired(required=false)
    public SpringBootJerseyRestApplication(ApplicationContext context) {
        this(context, (Module)GlobalState.state.getModules().firstValue(null));
    }

    @Autowired(required=false)
    public SpringBootJerseyRestApplication(ApplicationContext context, Module module) {
        ModuleDataExtractor extractor = new ModuleDataExtractor(module);
        LinkedListX allResources = extractor.getRestResources(context);
        System.out.println("Resources " + allResources);
        Map serverProperties = module.getServerProperties();
        if (allResources != null) {
            for (Map.Entry next : allResources) {
                if (this.isSingleton(next)) {
                    this.register(next);
                    continue;
                }
                this.register(next.getClass());
            }
        }
        if (serverProperties.isEmpty()) {
            this.property("jersey.config.beanValidation.enableOutputValidationErrorEntity.server", true);
            this.property("jersey.config.server.response.setStatusOverSendError", "true");
        } else {
            for (Map.Entry entry : serverProperties.entrySet()) {
                this.property((String)entry.getKey(), entry.getValue());
            }
        }
        context.getBeansOfType(AbstractBinder.class).forEach((n, e) -> this.register(e));
        module.getDefaultJaxRsPackages().stream().forEach(e -> this.packages(new String[]{e}));
        module.getDefaultResources().stream().forEach(e -> this.register((Class)e));
        module.getResourceConfigManager().accept(new JaxRsProvider((Object)this));
    }

    private boolean isSingleton(Object next) {
        if (next instanceof RestResource) {
            return ((RestResource)next).isSingleton();
        }
        Rest rest = next.getClass().getAnnotation(Rest.class);
        if (rest == null) {
            return !(next instanceof Class);
        }
        return rest.isSingleton();
    }
}

