/*
 * Decompiled with CFR 0.152.
 */
package com.oath.micro.server.spring.boot;

import com.oath.cyclops.types.persistent.PersistentList;
import com.oath.micro.server.config.Config;
import com.oath.micro.server.module.Environment;
import com.oath.micro.server.module.Module;
import com.oath.micro.server.module.ModuleDataExtractor;
import com.oath.micro.server.servers.FilterConfigurer;
import com.oath.micro.server.servers.ServletConfigurer;
import com.oath.micro.server.servers.ServletContextListenerConfigurer;
import com.oath.micro.server.servers.model.ServerData;
import com.oath.micro.server.spring.SpringBuilder;
import com.oath.micro.server.spring.boot.JerseySpringBootFrontEndApplication;
import cyclops.collections.immutable.LinkedListX;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.embedded.ServletContextInitializer;
import org.springframework.boot.context.web.SpringBootServletInitializer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.web.context.ContextLoader;

public class BootFrontEndApplicationConfigurator
extends SpringBootServletInitializer
implements SpringBuilder {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public ConfigurableApplicationContext createSpringApp(Config config, Class ... classes) {
        ArrayList<Class> classList = new ArrayList<Class>();
        classList.addAll(Arrays.asList(classes));
        classList.add(JerseySpringBootFrontEndApplication.class);
        classList.add(MyWebAppInitializer.class);
        SpringApplicationBuilder builder = new SpringApplicationBuilder((Object[])classList.toArray(new Class[0]));
        new JerseySpringBootFrontEndApplication(classList).config(builder);
        return builder.application().run(new String[0]);
    }

    @Component
    static class MyWebAppInitializer
    implements ServletContextInitializer {
        private final Environment environment;
        private final Module module;
        private final ApplicationContext rootContext;

        @Autowired(required=false)
        public MyWebAppInitializer(Environment env, ApplicationContext rootContext, Module m) {
            this.environment = env;
            this.rootContext = rootContext;
            this.module = m;
        }

        @Autowired(required=false)
        public MyWebAppInitializer(Environment env, ApplicationContext rootContext) {
            this(env, rootContext, () -> "");
        }

        public void onStartup(ServletContext webappContext) throws ServletException {
            ModuleDataExtractor extractor = new ModuleDataExtractor(this.module);
            this.environment.assureModule(this.module);
            String fullRestResource = "/" + this.module.getContext() + "/*";
            ServerData serverData = new ServerData(this.environment.getModuleBean(this.module).getPort(), Arrays.asList(new Object[0]), this.rootContext, fullRestResource, this.module);
            List filterDataList = extractor.createFilteredDataList(serverData);
            List servletDataList = extractor.createServletDataList(serverData);
            new ServletConfigurer(serverData, (PersistentList)LinkedListX.fromIterable((Iterable)servletDataList)).addServlets(webappContext);
            new FilterConfigurer(serverData, (PersistentList)LinkedListX.fromIterable((Iterable)filterDataList)).addFilters(webappContext);
            LinkedListX servletContextListenerData = LinkedListX.fromIterable((Iterable)this.module.getListeners(serverData)).filter(i -> !(i instanceof ContextLoader));
            LinkedListX servletRequestListenerData = LinkedListX.fromIterable((Iterable)this.module.getRequestListeners(serverData));
            new ServletContextListenerConfigurer(serverData, (PersistentList)servletContextListenerData, (PersistentList)servletRequestListenerData).addListeners(webappContext);
        }
    }
}

