/*
 * Decompiled with CFR 0.152.
 */
package com.oath.micro.server.spring.boot;

import com.oath.micro.server.module.Environment;
import com.oath.micro.server.servers.AccessLogLocationBean;
import com.oath.micro.server.spring.properties.PropertyFileConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.web.SpringBootServletInitializer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@PropertySource(value={"classpath:spring-boot-microserver.properties"})
public class JerseySpringBootFrontEndApplication
extends SpringBootServletInitializer {
    List<Class> classes = new ArrayList<Class>();

    public JerseySpringBootFrontEndApplication() {
    }

    public JerseySpringBootFrontEndApplication(List<Class> classes2) {
        this.classes.addAll(classes2);
        this.classes.add(JerseySpringBootFrontEndApplication.class);
        this.classes.add(PropertyFileConfig.class);
        this.classes.add(Environment.class);
        this.classes.add(AccessLogLocationBean.class);
    }

    protected SpringApplicationBuilder configure(SpringApplicationBuilder application) {
        return application.sources(this.classes.toArray(new Class[0]));
    }

    public SpringApplicationBuilder config(SpringApplicationBuilder builder) {
        return this.configure(builder);
    }

    @Bean
    public AccessLogLocationBean createAccessLogLocationBean(ApplicationContext rootContext) {
        Properties props = (Properties)rootContext.getBean("propertyFactory");
        String location = Optional.ofNullable((String)props.get("access.log.output")).orElse("./logs/");
        return new AccessLogLocationBean(location);
    }
}

