package com.obatis.orm.sql;

import com.obatis.orm.constant.SqlConstant;
import com.obatis.exception.HandleException;
import com.obatis.orm.provider.handle.QueryProviderHandle;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 基础sql提供类
 * @author HuangLongPu
 */
public class SqlProvider<T> {
	
	public SqlProvider() {}
	
	public String insert(@Param("request") T t, String tableName, Class<T> cls) throws HandleException {
		return SqlHandleProvider.getInsertSql(t, cls, tableName);
	}
	
	public String batchInsert(@Param("request") List<T> list, String tableName, Class<T> cls) throws HandleException {
		return SqlHandleProvider.getBatchInsertSql(list, cls, tableName);
	}
	
	public String update(@Param("request") Map<String, Object> providers, String tableName) throws HandleException {
		return SqlHandleProvider.getUpdateSql(providers, tableName);
	}
	
	public String batchUpdate(@Param("request") Map<String, Object> providers, String tableName) throws HandleException {
		return SqlHandleProvider.getBatchUpdateSql(providers, tableName);
	}
	
	public String deleteById(@Param("id") Object id, String tableName) throws HandleException {
		return SqlHandleProvider.getDeleteByIdSql(tableName);
	}
	
	public String delete(@Param("request") Map<String, Object> providers, String tableName) throws HandleException {
		return SqlHandleProvider.getDeleteSql(providers, tableName);
	}
	
	public String find(@Param("request") Map<String, Object> providers, String tableName) throws HandleException {
		return SqlHandleProvider.getSelectSql(providers, tableName);
	}

	public String list(@Param("request") Map<String, Object> providers, String tableName) throws HandleException {
		return SqlHandleProvider.getSelectSql(providers, tableName);
	}
	
	public String validate(@Param("request") Map<String, Object> providers, String tableName) throws HandleException {
		return SqlHandleProvider.getValidateSql(providers, tableName);
	}
	
	public String replaceSql(String sql, @Param("request") List<Object> params) {
		int index = 0;
		return SqlHandleProvider.getReplaceSql(sql, index);
	}

	public String returnParamSql(String sql, @Param("request") Map<String, Object> providers) {
		return sql;
	}
	
	public String pageSql(String sql, @Param("request") Map<String, Object> providers) {
		QueryProviderHandle queryProvider = (QueryProviderHandle) providers.get(SqlConstant.PROVIDER_OBJ);
		return SqlHandleProvider.appendPageSql(sql, queryProvider.getPage(), queryProvider.getLimit());
	}
}
