/*
 * Decompiled with CFR 0.152.
 */
package com.obatis.config.date;

import com.obatis.convert.date.DateCommonConvert;
import com.obatis.validate.ValidateTool;
import java.util.Date;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;

@Configuration
public class DateConverterConfig
implements Converter<String, Date> {
    public Date convert(String source) {
        if (ValidateTool.isEmpty((String)source)) {
            return null;
        }
        if (source.matches("^\\d{4}-\\d{1,2}$")) {
            return DateCommonConvert.parseDate((String)source, (String)"yyyy-MM");
        }
        if (source.matches("^\\d{4}-\\d{1,2}-\\d{1,2}$")) {
            return DateCommonConvert.parseDate((String)source, (String)"yyyy-MM-dd");
        }
        if (source.matches("^\\d{4}-\\d{1,2}-\\d{1,2} {1}\\d{1,2}$")) {
            return DateCommonConvert.parseDate((String)source, (String)"yyyy-MM-dd HH");
        }
        if (source.matches("^\\d{4}-\\d{1,2}-\\d{1,2} {1}\\d{1,2}:\\d{1,2}$")) {
            return DateCommonConvert.parseDate((String)source, (String)"yyyy-MM-dd HH:mm");
        }
        if (source.matches("^\\d{4}-\\d{1,2}-\\d{1,2} {1}\\d{1,2}:\\d{1,2}:\\d{1,2}$")) {
            return DateCommonConvert.parseDate((String)source, (String)"yyyy-MM-dd HH:mm:ss");
        }
        throw new IllegalArgumentException("error: invalid value '" + source + "'");
    }
}

