/*
 * Decompiled with CFR 0.152.
 */
package com.obatis.config.request;

import com.obatis.config.request.RequestInfo;
import eu.bitwalker.useragentutils.DeviceType;
import eu.bitwalker.useragentutils.OperatingSystem;
import eu.bitwalker.useragentutils.UserAgent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class RequestHandleInfo {
    public static String getRequestIp(HttpServletRequest request) {
        String ipAddress = request.getHeader("x-forwarded-for");
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("Proxy-Client-IP");
        }
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("X-Real-IP");
        }
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getRemoteAddr();
        }
        if (ipAddress.equals("127.0.0.1") || ipAddress.equals("0:0:0:0:0:0:0:1")) {
            InetAddress inet = null;
            try {
                inet = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
            ipAddress = inet.getHostAddress();
        }
        if (ipAddress != null && ipAddress.length() > 15 && ipAddress.indexOf(",") > 0) {
            ipAddress = ipAddress.substring(0, ipAddress.indexOf(","));
        }
        return ipAddress;
    }

    public static RequestInfo getRequestInfo(HttpServletRequest request) {
        String agentString = request.getHeader("User-Agent");
        UserAgent userAgent = UserAgent.parseUserAgentString((String)agentString);
        OperatingSystem operatingSystem = userAgent.getOperatingSystem();
        String browser = userAgent.getBrowser() + " " + userAgent.getBrowserVersion();
        DeviceType deviceType = operatingSystem.getDeviceType();
        String device = null;
        switch (deviceType) {
            case COMPUTER: {
                device = "PC";
                break;
            }
            case TABLET: {
                if (agentString.contains("Android")) {
                    device = "Android Pad";
                    break;
                }
                if (agentString.contains("iOS")) {
                    device = "iPad";
                    break;
                }
                device = "Unknown";
                break;
            }
            case MOBILE: {
                if (agentString.contains("Android")) {
                    device = "Android";
                    break;
                }
                if (agentString.contains("iOS")) {
                    device = "IOS";
                    break;
                }
                device = "Unknown";
                break;
            }
            default: {
                device = "Unknown";
            }
        }
        RequestInfo info = new RequestInfo();
        info.setRequestBrowser(browser);
        info.setDeviceType(device);
        info.setRequestSystem(operatingSystem.getName());
        info.setRequestIp(RequestHandleInfo.getRequestIp(request));
        return info;
    }

    public static String getAuthUserToken() {
        RequestAttributes requestAttributes = RequestContextHolder.currentRequestAttributes();
        HttpServletRequest request = ((ServletRequestAttributes)requestAttributes).getRequest();
        return request.getHeader("accountToken");
    }
}

