/*
 * Decompiled with CFR 0.152.
 */
package com.obatis.config.response.result;

import com.obatis.config.response.result.ResultResponse;
import com.obatis.core.exception.HandleException;
import com.obatis.core.exception.NotAuthHandleException;
import com.obatis.core.exception.NotLoginHandleException;
import com.obatis.core.logger.LogPrintFactory;
import com.obatis.core.logger.LogPrinter;
import com.obatis.validate.ValidateTool;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.NoHandlerFoundException;

@RestControllerAdvice
public class ExceptionRestHandleAdvice {
    private static final LogPrinter LOG = LogPrintFactory.getLogPrint(ExceptionRestHandleAdvice.class);

    @ExceptionHandler(value={Exception.class})
    public ResultResponse handler(HttpServletResponse response, Exception exception) {
        if (response.getStatus() == HttpStatus.BAD_REQUEST.value()) {
            response.setStatus(HttpStatus.OK.value());
        }
        ResultResponse resultInfo = new ResultResponse();
        String errorCode = null;
        if (exception instanceof HandleException) {
            LOG.print(exception.getMessage());
            resultInfo.setCode(5000);
            resultInfo.setMessage(ValidateTool.isHaveChinese((String)exception.getMessage()) ? exception.getMessage() : "\u4e1a\u52a1\u5f02\u5e38");
            errorCode = ((HandleException)exception).getErrCode();
        } else if (exception instanceof MethodArgumentNotValidException) {
            System.out.println(exception.getMessage());
            MethodArgumentNotValidException e1 = (MethodArgumentNotValidException)exception;
            BindingResult bindingResult = e1.getBindingResult();
            List allErrors = bindingResult.getAllErrors();
            ArrayList<String> errorMsgs = new ArrayList<String>();
            for (ObjectError errorInfo : allErrors) {
                FieldError fieldError = (FieldError)errorInfo;
                errorMsgs.add(fieldError.getDefaultMessage());
            }
            String join = String.join((CharSequence)",", errorMsgs);
            resultInfo.setCode(3001);
            resultInfo.setMessage(ValidateTool.isHaveChinese((String)join) ? join : "\u8bf7\u6c42\u53c2\u6570\u503c\u65e0\u6548");
            errorCode = "ERR0101";
            LOG.print("\u8bf7\u6c42\u53c2\u6570\u503c\u65e0\u6548\uff1a" + join);
        } else if (exception instanceof HttpMessageNotReadableException) {
            resultInfo.setCode(3002);
            resultInfo.setMessage("\u8bf7\u6c42\u53c2\u6570\u503c\u7c7b\u578b\u4e0d\u5339\u914d");
            errorCode = "ERR0102";
            LOG.print("\u8bf7\u6c42\u53c2\u6570\u503c\u7c7b\u578b\u4e0d\u5339\u914d\uff1a" + exception.getMessage());
        } else if (exception instanceof NotAuthHandleException) {
            resultInfo.setCode(6002);
            resultInfo.setMessage("\u8bf7\u6c42\u672a\u6388\u6743\uff0c\u6ca1\u6709\u64cd\u4f5c\u6743\u9650");
            errorCode = "ERR0104";
            LOG.print("\u8bf7\u6c42\u672a\u6388\u6743\uff0c\u6ca1\u6709\u64cd\u4f5c\u6743\u9650");
        } else if (exception instanceof NotLoginHandleException) {
            resultInfo.setCode(6001);
            resultInfo.setMessage("\u7528\u6237\u672a\u767b\u5f55");
            errorCode = "ERR0103";
            LOG.print("\u7528\u6237\u672a\u767b\u5f55," + exception.getMessage());
        } else if (exception instanceof NoHandlerFoundException) {
            resultInfo.setCode(404);
            resultInfo.setMessage("HTTP\u8bf7\u6c42URL\u5730\u5740\u4e0d\u6b63\u786e");
            errorCode = "ERR0201";
            LOG.print("HTTP\u8bf7\u6c42URL\u5730\u5740\u4e0d\u6b63\u786e" + exception.getMessage());
        } else if (exception instanceof NullPointerException) {
            String trace = ExceptionRestHandleAdvice.printExceptionLog(exception);
            resultInfo.setCode(5005);
            resultInfo.setMessage("\u8bf7\u6c42\u9519\u8bef");
            errorCode = "ERR0301";
            LOG.print("\u7a7a\u6307\u9488\u5f02\u5e38\uff1a" + trace);
        } else if (exception instanceof IndexOutOfBoundsException) {
            String trace = ExceptionRestHandleAdvice.printExceptionLog(exception);
            resultInfo.setCode(5005);
            resultInfo.setMessage("\u8bf7\u6c42\u9519\u8bef");
            errorCode = "ERR0302";
            LOG.print("\u64cd\u4f5c\u8d8a\u754c\u5f02\u5e38\uff1a" + trace);
        } else if (exception instanceof SQLException) {
            String trace = ExceptionRestHandleAdvice.printExceptionLog(exception);
            resultInfo.setCode(5005);
            resultInfo.setMessage("\u8bf7\u6c42\u9519\u8bef");
            errorCode = "ERR0303";
            LOG.print("SQL\u6267\u884c\u8fd0\u884c\u5f02\u5e38\uff1a" + trace);
        } else {
            String trace = ExceptionRestHandleAdvice.printExceptionLog(exception);
            resultInfo.setCode(5005);
            resultInfo.setMessage("\u8bf7\u6c42\u9519\u8bef");
            errorCode = "ERR03";
            LOG.print("\u7a0b\u5e8f\u6267\u884c\u9519\u8bef\uff1a" + trace);
        }
        if (ValidateTool.isEmpty((String)errorCode)) {
            errorCode = "ERR01";
        }
        resultInfo.setErrorCode(errorCode);
        return resultInfo;
    }

    private static String printExceptionLog(Throwable e) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        e.printStackTrace(printWriter);
        stringWriter.flush();
        printWriter.flush();
        return stringWriter.getBuffer().toString();
    }
}

