/*
 * Decompiled with CFR 0.152.
 */
package com.obatis.core.annotation.config;

import com.obatis.core.annotation.config.BeanAnotatioUrlHandle;
import com.obatis.validate.ValidateTool;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

public final class LoadAnnotationUrl {
    protected LoadAnnotationUrl() {
    }

    protected final void load(String baseDir) {
        Reflections reflections = new Reflections(baseDir, new Scanner[0]);
        Set controllerList = reflections.getTypesAnnotatedWith(Controller.class);
        Set restControllerList = reflections.getTypesAnnotatedWith(RestController.class);
        this.handleController(controllerList);
        this.handleRestController(restControllerList);
    }

    private final void handleController(Set<Class<?>> controllerList) {
        for (Class<?> cls : controllerList) {
            Controller controller = cls.getAnnotation(Controller.class);
            this.getAnnotationUrlPath(cls, this.handlePath(controller.value()));
        }
    }

    private void handleRestController(Set<Class<?>> restControllerList) {
        for (Class<?> cls : restControllerList) {
            RestController resController = cls.getAnnotation(RestController.class);
            this.getAnnotationUrlPath(cls, this.handlePath(resController.value()));
        }
    }

    private String handlePath(String annotationPath) {
        String path = null;
        if (!ValidateTool.isEmpty((String)annotationPath)) {
            path = annotationPath.startsWith("/") ? annotationPath : "/" + annotationPath;
        }
        if (path == null) {
            path = "";
        }
        return path;
    }

    private void getAnnotationUrlPath(Class<?> cls, String path) {
        String[] pathArr;
        RequestMapping mapping = cls.getAnnotation(RequestMapping.class);
        if (mapping != null && (pathArr = mapping.value()).length > 0 && !ValidateTool.isEmpty((String)pathArr[0])) {
            path = pathArr[0].startsWith("/") ? path + pathArr[0] : path + "/" + pathArr[0];
        }
        BeanAnotatioUrlHandle.handle(cls, cls.getCanonicalName(), path);
    }
}

