/*
 * Decompiled with CFR 0.152.
 */
package com.obatis.core.compile;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class JavaCompilerFactory {
    public static Class<?> compiler(String packageName, String fileName, String javaSource) throws URISyntaxException, ClassNotFoundException {
        JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager standardJavaFileManager = javaCompiler.getStandardFileManager(null, null, null);
        ClassJavaFileManager classJavaFileManager = new ClassJavaFileManager(standardJavaFileManager);
        HandleJavaFileObject handleJavaFileObject = new HandleJavaFileObject(new URI(fileName + ".java"), JavaFileObject.Kind.SOURCE, javaSource);
        JavaCompiler.CompilationTask task = javaCompiler.getTask(null, classJavaFileManager, null, null, null, Arrays.asList(handleJavaFileObject));
        if (task.call().booleanValue()) {
            CreateJavaClassFile javaFileObject = classJavaFileManager.getClassJavaFileObject();
            MemoryJavaClassLoader classLoader = new MemoryJavaClassLoader(javaFileObject);
            return classLoader.loadClass(packageName + "." + fileName);
        }
        return null;
    }

    static class MemoryJavaClassLoader
    extends ClassLoader {
        private CreateJavaClassFile createJavaClassFile;

        public MemoryJavaClassLoader(CreateJavaClassFile createJavaClassFile) {
            this.createJavaClassFile = createJavaClassFile;
        }

        @Override
        protected Class<?> findClass(String name) {
            byte[] bytes = this.createJavaClassFile.getBytes();
            return this.defineClass(name, bytes, 0, bytes.length);
        }
    }

    static class HandleJavaFileObject
    extends SimpleJavaFileObject {
        private String content;

        public HandleJavaFileObject(URI uri, JavaFileObject.Kind kind, String content) {
            super(uri, kind);
            this.content = content;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this.content;
        }
    }

    static class CreateJavaClassFile
    extends SimpleJavaFileObject {
        private ByteArrayOutputStream outputStream = new ByteArrayOutputStream();

        public CreateJavaClassFile(String className, JavaFileObject.Kind kind) {
            super(URI.create(className + kind.extension), kind);
        }

        @Override
        public OutputStream openOutputStream() {
            return this.outputStream;
        }

        public byte[] getBytes() {
            return this.outputStream.toByteArray();
        }
    }

    static class ClassJavaFileManager
    extends ForwardingJavaFileManager {
        private CreateJavaClassFile classJavaFileObject;

        public ClassJavaFileManager(JavaFileManager fileManager) {
            super(fileManager);
        }

        public CreateJavaClassFile getClassJavaFileObject() {
            return this.classJavaFileObject;
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject fileObject) {
            this.classJavaFileObject = new CreateJavaClassFile(className, kind);
            return this.classJavaFileObject;
        }
    }
}

