/*
 * Decompiled with CFR 0.152.
 */
package com.obatis.email.impl;

import com.obatis.email.SendMailService;
import com.obatis.email.exception.SendMailException;
import java.util.Map;
import javax.annotation.Resource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.springframework.core.env.Environment;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Component;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;

@Component
public class SendMailServiceImpl
implements SendMailService {
    @Resource
    private Environment env;
    @Resource
    private TemplateEngine templateEngine;
    private static JavaMailSender mailSender;
    private static String fromEmail;

    @Override
    public void send(String toEmail, String title, String content) throws SendMailException {
        SendMailServiceImpl.getJavaMailSender(this.env);
        MimeMessage message = mailSender.createMimeMessage();
        try {
            MimeMessageHelper helper = new MimeMessageHelper(message, true);
            helper.setFrom(fromEmail);
            helper.setTo(toEmail);
            helper.setSubject(title);
            helper.setText(content, true);
            mailSender.send(message);
        }
        catch (MessagingException e) {
            e.printStackTrace();
            throw new SendMailException("error:" + e.getMessage());
        }
    }

    @Override
    public void sendTemplate(String toEmail, String title, String templatePath, Map<String, Object> params) throws SendMailException {
        Context context = new Context();
        context.setVariables(params);
        this.send(toEmail, title, this.templateEngine.process(templatePath, (IContext)context));
    }

    private static JavaMailSender getJavaMailSender(Environment env) {
        if (mailSender == null) {
            return SendMailServiceImpl.loadJavaMailSender(env);
        }
        return mailSender;
    }

    private static synchronized JavaMailSender loadJavaMailSender(Environment env) {
        if (mailSender == null) {
            mailSender = new JavaMailSenderImpl();
            ((JavaMailSenderImpl)mailSender).setHost(env.getProperty("spring.mail.host"));
            ((JavaMailSenderImpl)mailSender).setUsername(env.getProperty("spring.mail.username"));
            ((JavaMailSenderImpl)mailSender).setPassword(env.getProperty("spring.mail.password"));
            ((JavaMailSenderImpl)mailSender).setDefaultEncoding(env.getProperty("spring.mail.default-encoding", "UTF-8"));
            fromEmail = env.getProperty("mail.fromMail.addr");
        }
        return mailSender;
    }

    static {
        fromEmail = null;
    }
}

