/*
 * Decompiled with CFR 0.152.
 */
package com.obatis.redis.handle;

import com.obatis.convert.CommonConvert;
import com.obatis.convert.JsonCommonConvert;
import com.obatis.core.exception.HandleException;
import com.obatis.validate.ValidateTool;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class RedisHandle {
    @Resource
    private RedisTemplate<String, Object> redisTemplate;

    public void expire(String key, int timeout) {
        this.redisTemplate.expire((Object)key, (long)timeout, TimeUnit.SECONDS);
    }

    public void set(String key, Object value) {
        this.redisTemplate.opsForValue().set((Object)key, value);
    }

    public void set(String key, Object value, int timeout) {
        this.redisTemplate.expire((Object)key, (long)timeout, TimeUnit.SECONDS);
        this.redisTemplate.opsForValue().set((Object)key, value);
    }

    public Object get(String key) {
        return this.redisTemplate.opsForValue().get((Object)key);
    }

    public void remove(String key) {
        this.redisTemplate.delete((Object)key);
    }

    public void setList(String key, List<?> list) {
        this.validateDate(key, list);
        String data = JsonCommonConvert.objConvertJson(list);
        this.set(key, data);
    }

    public void setList(String key, List<?> list, int timeout) {
        this.validateDate(key, list);
        this.redisTemplate.expire((Object)key, (long)timeout, TimeUnit.SECONDS);
        String data = JsonCommonConvert.objConvertJson(list);
        this.set(key, data);
    }

    private void validateDate(String key, List<?> list) throws HandleException {
        if (ValidateTool.isEmpty((String)key)) {
            throw new HandleException("error : key is empty!");
        }
        if (list == null) {
            throw new HandleException("error : list is empty!");
        }
    }

    public <M> List<M> getList(String key, Class<M> cls) {
        if (ValidateTool.isEmpty((String)key)) {
            throw new HandleException("error : key is empty!!!");
        }
        Object data = this.get(key);
        String jsonStr = CommonConvert.toString((Object)data);
        return JsonCommonConvert.jsonConvertList((String)jsonStr, cls);
    }
}

