/*
 * Decompiled with CFR 0.152.
 */
package com.obatis.redis.handle;

import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class RedisMapHandle<MK, MV> {
    @Resource
    public RedisTemplate<String, Map<MK, MV>> redisTemplate;

    public void set(String key, MK mk, MV mv) {
        this.redisTemplate.opsForHash().put((Object)key, mk, mv);
    }

    public void set(String key, Map<MK, MV> value) {
        this.redisTemplate.opsForHash().putAll((Object)key, value);
    }

    public Map<MK, MV> get(String key) {
        HashOperations opsForMap = this.redisTemplate.opsForHash();
        return opsForMap.entries((Object)key);
    }

    public MV get(String key, MK mk) {
        HashOperations opsForMap = this.redisTemplate.opsForHash();
        return (MV)opsForMap.get((Object)key, mk);
    }

    public List<MV> list(String key) {
        HashOperations opsForMap = this.redisTemplate.opsForHash();
        return opsForMap.values((Object)key);
    }

    public List<MV> list(String key, List<MK> hashKeys) {
        HashOperations opsForMap = this.redisTemplate.opsForHash();
        return opsForMap.multiGet((Object)key, hashKeys);
    }

    public Long size(String key) {
        return this.redisTemplate.opsForHash().size((Object)key);
    }

    public void remove(String key, MK ... hashKeys) {
        this.redisTemplate.opsForHash().delete((Object)key, (Object[])hashKeys);
    }

    public void delete(String key) {
        this.redisTemplate.delete((Object)key);
    }
}

