/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.docker.commands;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.ApplicationConsole;
import com.oracle.bedrock.runtime.MetaClass;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.console.CapturingApplicationConsole;
import com.oracle.bedrock.runtime.docker.Docker;
import com.oracle.bedrock.runtime.docker.commands.CommandWithArgumentList;
import com.oracle.bedrock.runtime.options.Argument;
import com.oracle.bedrock.runtime.options.Arguments;
import com.oracle.bedrock.runtime.options.Console;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonReader;
import javax.json.JsonValue;

public class Inspect
extends CommandWithArgumentList<Inspect> {
    private Inspect(List<?> names) {
        super("inspect", names);
    }

    private Inspect(Arguments arguments, List<?> names) {
        super(arguments, names);
    }

    public Inspect format(String format) {
        if (format == null || format.trim().isEmpty()) {
            return this;
        }
        return (Inspect)this.withCommandArguments(new Argument[]{Argument.of((String)"--format", (char)'=', (Object)format, (Option[])new Option[0])});
    }

    public Inspect includeSizes(boolean include) {
        if (include) {
            return (Inspect)this.withCommandArguments(new Argument[]{Argument.of((Object)"--size", (Option[])new Option[0])});
        }
        return (Inspect)this.withoutCommandArguments(new Argument[]{Argument.of((Object)"--size", (Option[])new Option[0])});
    }

    @Override
    protected Inspect withCommandArguments(List<Argument> names, Argument ... args) {
        return new Inspect(this.getCommandArguments().with(args), names);
    }

    @Override
    protected Inspect withoutCommandArguments(List<Argument> names, Argument ... args) {
        return new Inspect(this.getCommandArguments().without(args), names);
    }

    public static Inspect image(List<?> names) {
        return (Inspect)new Inspect(names).withCommandArguments(new Argument[]{Argument.of((String)"--type", (char)'=', (Object)"image", (Option[])new Option[0])});
    }

    public static Inspect image(Object ... names) {
        return Inspect.image(Arrays.asList(names));
    }

    public static Inspect container(List<?> names) {
        return (Inspect)new Inspect(names).withCommandArguments(new Argument[]{Argument.of((String)"--type", (char)'=', (Object)"container", (Option[])new Option[0])});
    }

    public static Inspect container(Object ... names) {
        return Inspect.container(Arrays.asList(names));
    }

    public JsonValue run(Platform platform, Docker environment) {
        CapturingApplicationConsole console = new CapturingApplicationConsole();
        try (Application app = platform.launch((MetaClass)this, new Option[]{environment, Console.of((ApplicationConsole)console)});){
            if (app.waitFor(new Option[0]) != 0) {
                console.getCapturedOutputLines().forEach(System.out::println);
                console.getCapturedErrorLines().forEach(System.err::println);
                JsonValue jsonValue = null;
                return jsonValue;
            }
        }
        Queue lines = console.getCapturedOutputLines();
        String json = lines.stream().filter(line -> line != null && !line.equals("(terminated)")).collect(Collectors.joining("\n")).trim();
        if (!json.startsWith("[") && !json.startsWith("{")) {
            json = "[" + json + "]";
        }
        JsonReader reader = Json.createReader((Reader)new StringReader(json));
        try {
            return reader.read();
        }
        catch (Exception e) {
            System.err.println("Error parsing JSON");
            System.err.println(json);
            e.printStackTrace();
            return null;
        }
    }
}

