/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.docker;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.LocalPlatform;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.docker.machine.DockerMachine;
import com.oracle.bedrock.runtime.docker.options.DockerDefaultBaseImages;
import com.oracle.bedrock.runtime.options.Argument;
import com.oracle.bedrock.runtime.options.EnvironmentVariable;
import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class Docker
implements Option {
    public static final String ENV_DOCKER_API_VERSION = "DOCKER_API_VERSION";
    public static final String ENV_DOCKER_CONFIG = "DOCKER_CONFIG";
    public static final String ENV_DOCKER_CERT_PATH = "DOCKER_CERT_PATH";
    public static final String ENV_DOCKER_DRIVER = "DOCKER_DRIVER";
    public static final String ENV_DOCKER_HOST = "DOCKER_HOST";
    public static final String ENV_DOCKER_NOWARN_KERNEL_VERSION = "DOCKER_NOWARN_KERNEL_VERSION";
    public static final String ENV_DOCKER_RAMDISK = "DOCKER_RAMDISK";
    public static final String ENV_DOCKER_TLS_VERIFY = "DOCKER_TLS_VERIFY";
    public static final String ENV_DOCKER_CONTENT_TRUST = "DOCKER_CONTENT_TRUST";
    public static final String ENV_DOCKER_CONTENT_TRUST_SERVER = "DOCKER_CONTENT_TRUST_SERVER";
    public static final String ENV_DOCKER_TMPDIR = "DOCKER_TMPDIR";
    public static final String ARG_CONFIG = "--config";
    public static final String ARG_DEBUG = "--debug";
    public static final String ARG_HOST = "--host";
    public static final String ARG_HELP = "--help";
    public static final String ARG_LOG_LEVEL = "--log-level";
    public static final String ARG_TLS = "--tls";
    public static final String ARG_TLS_CA_CERT = "--tlscacert";
    public static final String ARG_TLS_CERT = "--tlscert";
    public static final String ARG_TLS_KEY = "--tlskey";
    public static final String ARG_TLS_VERIFY = "--tlsverify";
    public static final String ARG_VERSION = "--version";
    public static final String DEFAULT_EXECUTABLE = "docker";
    private final List<EnvironmentVariable> environmentVariables;
    private final List<Argument> arguments;
    private final String dockerExecutable;
    private final DockerDefaultBaseImages baseImages;
    private String defaultNetwork;
    private final String daemonAddress;

    private Docker(String daemonAddress, String executable, List<EnvironmentVariable> environmentVariables, List<Argument> arguments, DockerDefaultBaseImages baseImages) {
        this.daemonAddress = daemonAddress;
        this.baseImages = baseImages;
        this.environmentVariables = Collections.unmodifiableList(environmentVariables);
        this.arguments = Collections.unmodifiableList(arguments);
        if (executable == null || executable.isEmpty()) {
            executable = DEFAULT_EXECUTABLE;
        }
        this.dockerExecutable = executable;
    }

    public Docker withDaemonAddress(String address) {
        return new Docker(address, this.dockerExecutable, this.environmentVariables, this.replaceArgument(this.arguments, Argument.of((String)ARG_HOST, (char)'=', (Object)address, (Option[])new Option[0])), this.baseImages);
    }

    public String getDaemonAddress() {
        return this.daemonAddress;
    }

    public Docker dockerExecutableOf(String executable) {
        if (this.dockerExecutable.equals(executable)) {
            return this;
        }
        return new Docker(this.daemonAddress, executable, this.environmentVariables, this.arguments, this.baseImages);
    }

    public String getDockerExecutable() {
        return this.dockerExecutable;
    }

    public List<Argument> getArguments() {
        return Collections.unmodifiableList(this.arguments);
    }

    public List<EnvironmentVariable> getEnvironmentVariables() {
        return Collections.unmodifiableList(this.environmentVariables);
    }

    public Docker withBaseImage(Class<? extends Application> applicationClass, String baseImageName) {
        if (applicationClass == null) {
            throw new IllegalArgumentException("The application Class cannot be null");
        }
        if (baseImageName == null || baseImageName.trim().isEmpty()) {
            throw new IllegalArgumentException("The base image name cannot be null or blank");
        }
        if (this.getBaseImage(applicationClass).equals(baseImageName)) {
            return this;
        }
        DockerDefaultBaseImages images = this.baseImages.with(applicationClass, baseImageName);
        return new Docker(this.daemonAddress, this.dockerExecutable, this.environmentVariables, this.arguments, images);
    }

    public String getBaseImage(Class<? extends Application> applicationClass) {
        return this.baseImages.getBaseImage(applicationClass);
    }

    public Docker withDefaultNetwork(String networkName) {
        Docker docker = new Docker(this.daemonAddress, this.dockerExecutable, this.environmentVariables, this.arguments, this.baseImages);
        docker.defaultNetwork = networkName;
        return docker;
    }

    public String getDefaultNetworkName() {
        return this.defaultNetwork;
    }

    public Docker configAt(Object config) {
        return this.withCommandOptions(Argument.of((String)ARG_CONFIG, (char)'=', (Object)config, (Option[])new Option[0]));
    }

    public Docker debug(boolean enabled) {
        return this.withCommandOptions(Argument.of((String)ARG_DEBUG, (char)'=', (Object)enabled, (Option[])new Option[0]));
    }

    public Docker logLevel(String level) {
        return this.withCommandOptions(Argument.of((String)ARG_LOG_LEVEL, (char)'=', (Object)level, (Option[])new Option[0]));
    }

    public Docker tls(boolean enabled) {
        return this.withCommandOptions(Argument.of((String)ARG_TLS, (char)'=', (Object)enabled, (Option[])new Option[0]));
    }

    public Docker tlsCACert(File location) {
        return this.withCommandOptions(Argument.of((String)ARG_TLS_CA_CERT, (char)'=', (Object)location, (Option[])new Option[0]));
    }

    public Docker tlsCert(File location) {
        return this.withCommandOptions(Argument.of((String)ARG_TLS_CERT, (char)'=', (Object)location, (Option[])new Option[0]));
    }

    public Docker tlsKey(File location) {
        return this.withCommandOptions(Argument.of((String)ARG_TLS_KEY, (char)'=', (Object)location, (Option[])new Option[0]));
    }

    public Docker tlsVerify(boolean verify) {
        return this.withCommandOptions(Argument.of((String)ARG_TLS_VERIFY, (char)'=', (Object)verify, (Option[])new Option[0]));
    }

    public Docker apiVersion(String version) {
        return this.withEnvironmentVariables(EnvironmentVariable.of((String)ENV_DOCKER_API_VERSION, (String)version));
    }

    public Docker driver(String driver) {
        return this.withEnvironmentVariables(EnvironmentVariable.of((String)ENV_DOCKER_DRIVER, (String)driver));
    }

    public Docker noWarnKernelVersion(boolean noWarn) {
        return this.withEnvironmentVariables(EnvironmentVariable.of((String)ENV_DOCKER_NOWARN_KERNEL_VERSION, (Object)noWarn));
    }

    public Docker ramDisk(boolean use) {
        return this.withEnvironmentVariables(EnvironmentVariable.of((String)ENV_DOCKER_RAMDISK, (Object)use));
    }

    public Docker contentTrustEnabled(boolean enabled) {
        return this.withEnvironmentVariables(EnvironmentVariable.of((String)ENV_DOCKER_CONTENT_TRUST, (Object)enabled));
    }

    public Docker contentTrustAt(String url) {
        return this.withEnvironmentVariables(EnvironmentVariable.of((String)ENV_DOCKER_CONTENT_TRUST_SERVER, (String)url));
    }

    public Docker tempFilesAt(File temp) {
        return this.withEnvironmentVariables(EnvironmentVariable.of((String)ENV_DOCKER_TMPDIR, (Object)temp));
    }

    public Docker withCommandOptions(Argument ... opts) {
        return new Docker(this.daemonAddress, this.dockerExecutable, this.environmentVariables, this.replaceArgument(this.arguments, opts), this.baseImages);
    }

    public Docker withEnvironmentVariables(EnvironmentVariable ... environmentVariables) {
        return this.withEnvironmentVariables(Arrays.asList(environmentVariables));
    }

    public Docker withEnvironmentVariables(List<EnvironmentVariable> environmentVariables) {
        return new Docker(this.daemonAddress, this.dockerExecutable, this.replaceEnvVariable(this.environmentVariables, environmentVariables), this.arguments, this.baseImages);
    }

    private List<Argument> replaceArgument(List<Argument> toCopy, Argument ... arguments) {
        ArrayList<Argument> copy = new ArrayList<Argument>(toCopy);
        for (Argument argument : arguments) {
            String name = argument.getName();
            List existing = toCopy.stream().filter(arg -> arg.getName().equals(name)).collect(Collectors.toList());
            if (!existing.isEmpty()) {
                copy.removeAll(existing);
            }
            copy.add(argument);
        }
        return copy;
    }

    private List<EnvironmentVariable> replaceEnvVariable(List<EnvironmentVariable> toCopy, List<EnvironmentVariable> environmentVariables) {
        ArrayList<EnvironmentVariable> copy = new ArrayList<EnvironmentVariable>(toCopy);
        for (EnvironmentVariable environmentVariable : environmentVariables) {
            String name = environmentVariable.getName();
            List existing = copy.stream().filter(env -> env.getName().equals(name)).collect(Collectors.toList());
            if (!existing.isEmpty()) {
                copy.removeAll(existing);
            }
            copy.add(environmentVariable);
        }
        return copy;
    }

    protected InetAddress getValidLocalAddress() {
        String[] parts;
        InetAddress localAddress = LocalPlatform.get().getAddress();
        if (this.daemonAddress.startsWith("tcp://") && (parts = this.daemonAddress.substring(6).split(":")).length == 2) {
            try {
                int port = Integer.parseInt(parts[1]);
                InetSocketAddress socketAddress = new InetSocketAddress(parts[0], port);
                try (Socket socket = new Socket();){
                    socket.connect(socketAddress);
                    localAddress = socket.getLocalAddress();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return localAddress;
    }

    public InetAddress getDaemonInetAddress(Platform clientPlatform) {
        String[] parts;
        InetAddress address = clientPlatform.getAddress();
        if (this.daemonAddress.startsWith("tcp://") && (parts = this.daemonAddress.substring(6).split(":")).length == 2) {
            try {
                address = InetAddress.getByName(parts[0]);
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
        return address;
    }

    @OptionsByType.Default
    public static Docker auto() {
        ArrayList<EnvironmentVariable> environmentVariables = new ArrayList<EnvironmentVariable>();
        ArrayList<Argument> arguments = new ArrayList<Argument>();
        return new Docker(null, DEFAULT_EXECUTABLE, environmentVariables, arguments, DockerDefaultBaseImages.defaultImages());
    }

    public static Docker machine(String machineName) {
        return Docker.machine(machineName, DockerMachine.local(), new Option[0]);
    }

    public static Docker machine(String machineName, DockerMachine machine, Option ... options) {
        OptionsByType machineOptions = OptionsByType.of((Option[])options);
        List<EnvironmentVariable> environmentVariables = machine.environmentFor(machineName);
        String dockerHost = environmentVariables.stream().filter(envVar -> envVar.getName().equals(ENV_DOCKER_HOST)).findFirst().map(envVar -> String.valueOf(envVar.getValue())).orElse(null);
        Docker docker = (Docker)machineOptions.get(Docker.class, new Object[0]);
        return docker.withDaemonAddress(dockerHost).withEnvironmentVariables(environmentVariables).withCommandOptions(Argument.of((String)ARG_HOST, (char)'=', (Object)dockerHost, (Option[])new Option[0]));
    }

    public static Docker daemonAt(String address) {
        ArrayList<EnvironmentVariable> environmentVariables = new ArrayList<EnvironmentVariable>();
        ArrayList<Argument> arguments = new ArrayList<Argument>();
        arguments.add(Argument.of((String)ARG_HOST, (char)'=', (Object)address, (Option[])new Option[0]));
        return new Docker(address, DEFAULT_EXECUTABLE, environmentVariables, arguments, DockerDefaultBaseImages.defaultImages());
    }
}

