/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.docker;

import com.oracle.bedrock.Bedrock;
import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.extensible.AbstractExtensible;
import com.oracle.bedrock.extensible.Feature;
import com.oracle.bedrock.io.FileHelper;
import com.oracle.bedrock.lang.StringHelper;
import com.oracle.bedrock.options.Timeout;
import com.oracle.bedrock.options.Variable;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.ApplicationConsole;
import com.oracle.bedrock.runtime.ApplicationProcess;
import com.oracle.bedrock.runtime.MetaClass;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.Profile;
import com.oracle.bedrock.runtime.console.EventsApplicationConsole;
import com.oracle.bedrock.runtime.console.NullApplicationConsole;
import com.oracle.bedrock.runtime.docker.Docker;
import com.oracle.bedrock.runtime.docker.DockerContainer;
import com.oracle.bedrock.runtime.docker.DockerImage;
import com.oracle.bedrock.runtime.docker.DockerPlatform;
import com.oracle.bedrock.runtime.docker.commands.Build;
import com.oracle.bedrock.runtime.docker.commands.Events;
import com.oracle.bedrock.runtime.docker.commands.Kill;
import com.oracle.bedrock.runtime.docker.commands.Remove;
import com.oracle.bedrock.runtime.docker.commands.Run;
import com.oracle.bedrock.runtime.docker.options.ContainerCloseBehaviour;
import com.oracle.bedrock.runtime.docker.options.DockerfileDeployer;
import com.oracle.bedrock.runtime.docker.options.ImageCloseBehaviour;
import com.oracle.bedrock.runtime.java.ClassPathModifier;
import com.oracle.bedrock.runtime.options.Arguments;
import com.oracle.bedrock.runtime.options.Console;
import com.oracle.bedrock.runtime.options.Discriminator;
import com.oracle.bedrock.runtime.options.DisplayName;
import com.oracle.bedrock.runtime.options.PlatformSeparators;
import com.oracle.bedrock.runtime.options.Ports;
import com.oracle.bedrock.runtime.options.WorkingDirectory;
import com.oracle.bedrock.runtime.remote.DeployedArtifacts;
import com.oracle.bedrock.runtime.remote.DeploymentArtifact;
import com.oracle.bedrock.runtime.remote.RemoteApplicationProcess;
import com.oracle.bedrock.runtime.remote.RemoteTerminal;
import com.oracle.bedrock.runtime.remote.options.Deployer;
import com.oracle.bedrock.table.Row;
import com.oracle.bedrock.table.Table;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.json.JsonObject;
import javax.json.JsonValue;

public class DockerRemoteTerminal
implements RemoteTerminal,
Deployer {
    private static Logger LOGGER = Logger.getLogger(DockerPlatform.class.getName());
    private Platform platform;
    private final DockerfileDeployer deployer;
    private final List<String> dockerFileCommands;
    private final File tmpFolder;

    public DockerRemoteTerminal(Platform platform) {
        try {
            this.platform = platform;
            this.tmpFolder = WorkingDirectory.temporaryDirectory().resolve(platform, OptionsByType.empty());
            this.deployer = new DockerfileDeployer(this.tmpFolder.getCanonicalPath(), new Option[0]);
            this.dockerFileCommands = new ArrayList<String>();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public DeployedArtifacts deploy(List<DeploymentArtifact> artifactsToDeploy, String remoteDirectory, Platform platform, Option ... deploymentOptions) {
        try {
            Files.createDirectories(this.tmpFolder.toPath(), new FileAttribute[0]);
            LOGGER.log(Level.INFO, "Deploying to " + this.tmpFolder);
            return this.deployer.deploy(artifactsToDeploy, remoteDirectory, platform, deploymentOptions);
        }
        catch (IOException e) {
            throw new RuntimeException("Error deploying artifacts", e);
        }
    }

    public DeployedArtifacts undeploy(DeployedArtifacts deployedArtifacts, Platform platform, Option ... deploymentOptions) {
        return this.deployer.undeploy(deployedArtifacts, platform, deploymentOptions);
    }

    public void makeDirectories(String directoryName, OptionsByType optionsByType) {
        this.dockerFileCommands.add("RUN mkdir -p " + directoryName);
    }

    public RemoteApplicationProcess launch(RemoteTerminal.Launchable launchable, Class<? extends Application> applicationClass, OptionsByType optionsByType) {
        String imageTag = UUID.randomUUID().toString();
        String containerName = UUID.randomUUID().toString();
        Docker docker = (Docker)optionsByType.get(Docker.class, new Object[0]);
        String baseImage = docker.getBaseImage(applicationClass);
        if (baseImage == null || baseImage.trim().isEmpty()) {
            throw new RuntimeException("Cannot find a suitable base image for application class " + applicationClass);
        }
        try {
            InetAddress localAddress = docker.getValidLocalAddress();
            optionsByType.add((Option)Variable.with((String)"local.address", (Object)localAddress.getHostAddress()));
            Files.createDirectories(this.tmpFolder.toPath(), new FileAttribute[0]);
            File dockerFile = this.writeDockerFile(launchable, baseImage, optionsByType);
            DockerImage image = this.createImage(imageTag, dockerFile, docker, optionsByType);
            ApplicationProcess containerProcess = this.runContainer(containerName, launchable, image, docker, optionsByType);
            if (containerProcess instanceof RemoteApplicationProcess) {
                RemoteApplicationProcess remoteApplicationProcess = (RemoteApplicationProcess)containerProcess;
                return remoteApplicationProcess;
            }
            WrapperRemoteApplicationProcess wrapperRemoteApplicationProcess = new WrapperRemoteApplicationProcess(containerProcess);
            return wrapperRemoteApplicationProcess;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "An error occurred. Attempting to kill and remove container " + containerName + " and remove image " + imageTag);
            this.safelyRemoveContainer(containerName, docker);
            this.safelyRemoveImage(imageTag, docker);
            throw new RuntimeException("An error occurred launching the application inside Docker", e);
        }
        finally {
            FileHelper.recursiveDelete((File)this.tmpFolder);
        }
    }

    protected File writeDockerFile(RemoteTerminal.Launchable launchable, String baseImage, OptionsByType optionsByType) throws IOException {
        WorkingDirectory workingDirectory = (WorkingDirectory)optionsByType.get(WorkingDirectory.class, new Object[0]);
        File workingDirectoryFile = workingDirectory.resolve(this.platform, optionsByType);
        String dockerFileName = "Dockerfile";
        File dockerFile = new File(this.tmpFolder, dockerFileName);
        Properties variables = launchable.getEnvironmentVariables(this.platform, optionsByType);
        for (String variableName : variables.stringPropertyNames()) {
            String value = StringHelper.doubleQuoteIfNecessary((String)variables.getProperty(variableName));
            this.dockerFileCommands.add(String.format("ENV %s=%s", variableName, value));
        }
        this.dockerFileCommands.add("WORKDIR " + workingDirectoryFile);
        try (PrintWriter writer = new PrintWriter(dockerFile);){
            writer.println("# ------------------------------------------------------------------------");
            writer.println("# Automatically generated Dockerfile");
            writer.println("# ------------------------------------------------------------------------");
            writer.printf("FROM %s\n\n", baseImage);
            this.dockerFileCommands.forEach(cmd -> writer.printf("%s\n\n", cmd));
            writer.println();
            this.deployer.write(writer);
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            Table diagnosticsTable = new Table(new Row[0]);
            Files.readAllLines(dockerFile.toPath()).forEach(xva$0 -> diagnosticsTable.addRow(new String[]{xva$0}));
            LOGGER.log(Level.INFO, "Oracle Bedrock " + Bedrock.getVersion() + ": Created Dockerfile for Application...\n------------------------------------------------------------------------\n" + diagnosticsTable.toString() + "\n------------------------------------------------------------------------\n");
        }
        return dockerFile;
    }

    protected DockerImage createImage(String imageTag, File dockerFile, Docker docker, OptionsByType optionsByType) {
        LOGGER.log(Level.INFO, "Building Docker Image...");
        DisplayName displayName = (DisplayName)optionsByType.getOrSetDefault(DisplayName.class, (Option)DisplayName.of((String)""));
        String dockerFileName = dockerFile.getName();
        Timeout timeout = (Timeout)optionsByType.getOrSetDefault(Timeout.class, (Option)Build.DEFAULT_TIMEOUT);
        try (Application application = this.platform.launch(Build.fromDockerFile(dockerFileName).withTags(imageTag).labels("oracle.bedrock.image=true").timeoutAfter(timeout), new Option[]{displayName, Discriminator.of((String)"Image"), docker, ImageCloseBehaviour.none(), WorkingDirectory.at((File)this.tmpFolder)});){
            if (application.waitFor(new Option[]{timeout}) != 0) {
                String msg = "An error occurred, build returned " + application.exitValue();
                LOGGER.log(Level.SEVERE, msg + ". Attempting to remove image " + imageTag);
                this.safelyRemoveImage(imageTag, docker);
                throw new RuntimeException(msg);
            }
            DockerImage image = (DockerImage)application.get(DockerImage.class);
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "Built Docker Image: " + imageTag);
            }
            DockerImage dockerImage = image;
            return dockerImage;
        }
    }

    protected ApplicationProcess runContainer(String containerName, RemoteTerminal.Launchable launchable, DockerImage image, Docker docker, OptionsByType optionsByType) {
        Timeout timeout = (Timeout)optionsByType.get(Timeout.class, new Object[0]);
        WorkingDirectory workingDirectory = (WorkingDirectory)optionsByType.get(WorkingDirectory.class, new Object[0]);
        String workingDirectoryName = workingDirectory.resolve(this.platform, optionsByType).toString();
        optionsByType.add((Option)PlatformSeparators.forUnix());
        optionsByType.add((Option)new CPModifier(workingDirectoryName));
        DisplayName displayName = (DisplayName)optionsByType.getOrSetDefault(DisplayName.class, (Option)DisplayName.of((String)"Container"));
        String command = launchable.getCommandToExecute(this.platform, optionsByType);
        List args = launchable.getCommandLineArguments(this.platform, optionsByType);
        Arguments containerArgs = Arguments.of((Object[])new Object[]{command}).with(args);
        Ports ports = (Ports)optionsByType.get(Ports.class, new Object[0]);
        List portList = ports.getPorts().stream().map(Ports.Port::getActualPort).collect(Collectors.toList());
        Run runCommand = Run.image(image, (Object)containerName).interactive().net(docker.getDefaultNetworkName()).hostName(containerName).env(launchable.getEnvironmentVariables(this.platform, optionsByType)).publish(portList).autoRemove();
        OptionsByType containerOptions = OptionsByType.of((OptionsByType)optionsByType).addAll(new Option[]{displayName, docker, WorkingDirectory.at((File)this.tmpFolder), ContainerCloseBehaviour.none(), ImageCloseBehaviour.remove(), containerArgs});
        EventsApplicationConsole.CountDownListener latch = new EventsApplicationConsole.CountDownListener(1);
        Predicate<String> predicate = line -> line.contains("container start");
        EventsApplicationConsole eventConsole = new EventsApplicationConsole().withStdOutListener(predicate, (EventsApplicationConsole.Listener)latch);
        try (Application events = this.platform.launch((MetaClass)Events.fromContainer(containerName), new Option[]{docker, Console.of((ApplicationConsole)eventConsole)});){
            ContainerApplication application = (ContainerApplication)this.platform.launch((MetaClass)new ContainerMetaClass(runCommand), containerOptions.asArray());
            DockerContainer container = (DockerContainer)application.get(DockerContainer.class);
            FeatureAddingProfile profile = new FeatureAddingProfile(image, container);
            optionsByType.add((Option)profile);
            optionsByType.add((Option)ImageCloseBehaviour.remove());
            try {
                if (!latch.await(timeout.to(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS)) {
                    throw new RuntimeException("Failed to detect container start event within " + timeout);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            JsonObject jsonNet = (JsonObject)container.inspect("{{json .NetworkSettings}}");
            if (!((JsonValue)jsonNet.get((Object)"Ports")).getValueType().equals((Object)JsonValue.ValueType.NULL)) {
                JsonObject jsonPorts = jsonNet.getJsonObject("Ports");
                List mappedPorts = ports.getPorts().stream().map(port -> {
                    String key = port.getActualPort() + "/tcp";
                    String hostPort = jsonPorts.getJsonArray(key).getJsonObject(0).getString("HostPort");
                    return new Ports.Port(port.getName(), port.getActualPort(), Integer.parseInt(hostPort));
                }).collect(Collectors.toList());
                optionsByType.remove(Ports.class);
                optionsByType.add((Option)Ports.of(mappedPorts));
            }
            ApplicationProcess applicationProcess = application.getProcess();
            return applicationProcess;
        }
    }

    private void safelyRemoveImage(String imageTag, Docker docker) {
        try (Application application = this.platform.launch((MetaClass)Remove.images(imageTag).force(), new Option[]{docker, NullApplicationConsole.builder()});){
            application.waitFor(new Option[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void safelyRemoveContainer(String containerName, Docker docker) {
        Throwable throwable;
        Application application2;
        try {
            application2 = this.platform.launch((MetaClass)Kill.containers(containerName), new Option[]{docker, NullApplicationConsole.builder()});
            throwable = null;
            try {
                application2.waitFor(new Option[0]);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (application2 != null) {
                    DockerRemoteTerminal.$closeResource(throwable, (AutoCloseable)application2);
                }
            }
        }
        catch (Exception application2) {
            // empty catch block
        }
        try {
            application2 = this.platform.launch((MetaClass)Remove.containers(containerName).force(), new Option[]{docker, NullApplicationConsole.builder()});
            throwable = null;
            try {
                application2.waitFor(new Option[0]);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                if (application2 != null) {
                    DockerRemoteTerminal.$closeResource(throwable, (AutoCloseable)application2);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class WrapperRemoteApplicationProcess
    implements RemoteApplicationProcess {
        private final ApplicationProcess process;

        public WrapperRemoteApplicationProcess(ApplicationProcess process) {
            this.process = process;
        }

        public void close() {
            this.process.close();
        }

        public long getId() {
            return this.process.getId();
        }

        public int exitValue() {
            return this.process.exitValue();
        }

        public InputStream getErrorStream() {
            return this.process.getErrorStream();
        }

        public InputStream getInputStream() {
            return this.process.getInputStream();
        }

        public OutputStream getOutputStream() {
            return this.process.getOutputStream();
        }

        public int waitFor(Option ... options) {
            return this.process.waitFor(options);
        }
    }

    private class FeatureAddingProfile
    implements Profile,
    Option {
        private Feature[] features;

        public FeatureAddingProfile(Feature ... features) {
            this.features = features;
        }

        public void onLaunching(Platform platform, MetaClass metaClass, OptionsByType optionsByType) {
        }

        public void onLaunched(Platform platform, Application application, OptionsByType optionsByType) {
            Arrays.stream(this.features).forEach(arg_0 -> ((Application)application).add(arg_0));
        }

        public void onClosing(Platform platform, Application application, OptionsByType optionsByType) {
        }
    }

    public static class ContainerMetaClass
    implements MetaClass<ContainerApplication> {
        private final Run runCommand;

        public ContainerMetaClass(Run runCommand) {
            this.runCommand = runCommand;
        }

        public Class<ContainerApplication> getImplementationClass(Platform platform, OptionsByType optionsByType) {
            return ContainerApplication.class;
        }

        public void onLaunching(Platform platform, OptionsByType optionsByType) {
            this.runCommand.onLaunching(platform, optionsByType);
        }

        public void onLaunch(Platform platform, OptionsByType optionsByType) {
            this.runCommand.onLaunch(platform, optionsByType);
        }

        public void onLaunched(Platform platform, ContainerApplication application, OptionsByType optionsByType) {
            this.runCommand.onLaunched(platform, application, optionsByType);
        }
    }

    public static class ContainerApplication
    extends AbstractExtensible
    implements Application {
        private final Platform platform;
        private final ApplicationProcess process;
        private final OptionsByType optionsByType;

        public ContainerApplication(Platform platform, ApplicationProcess process, OptionsByType optionsByType) {
            this.platform = platform;
            this.process = process;
            this.optionsByType = optionsByType;
        }

        public ApplicationProcess getProcess() {
            return this.process;
        }

        public void close() {
        }

        public String getName() {
            return null;
        }

        public Platform getPlatform() {
            return this.platform;
        }

        public boolean isOperational() {
            return true;
        }

        public void close(Option ... options) {
        }

        public int waitFor(Option ... options) {
            return 0;
        }

        public int exitValue() {
            return 0;
        }

        public long getId() {
            return 0L;
        }

        public Timeout getDefaultTimeout() {
            return null;
        }

        public OptionsByType getOptions() {
            return this.optionsByType;
        }
    }

    private class CPModifier
    extends ClassPathModifier {
        private String workingDirectory;

        CPModifier(String workingDirectory) {
            super(false);
            this.workingDirectory = workingDirectory;
        }

        public String modify(String classPath) {
            String path = super.modify(classPath);
            String modified = this.workingDirectory + "/:" + this.workingDirectory + "/*";
            return path.replace("./:./*", modified);
        }
    }
}

