/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.docker.commands;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.options.Timeout;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.MetaClass;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.SimpleApplication;
import com.oracle.bedrock.runtime.docker.Docker;
import com.oracle.bedrock.runtime.options.Argument;
import com.oracle.bedrock.runtime.options.Arguments;
import com.oracle.bedrock.runtime.options.Executable;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public abstract class AbstractDockerCommand<C extends AbstractDockerCommand>
implements MetaClass<Application> {
    private Timeout timeout = Timeout.after((long)2L, (TimeUnit)TimeUnit.MINUTES);
    private Arguments commandArguments;

    public AbstractDockerCommand(Arguments commandArguments) {
        this.commandArguments = commandArguments != null ? commandArguments : Arguments.empty();
    }

    public AbstractDockerCommand(String command) {
        this(Arguments.of((Argument[])new Argument[]{Argument.of((Object)command, (Option[])new Option[0])}));
    }

    public Class<? extends Application> getImplementationClass(Platform platform, OptionsByType optionsByType) {
        return SimpleApplication.class;
    }

    public void onLaunching(Platform platform, OptionsByType optionsByType) {
    }

    public void onLaunch(Platform platform, OptionsByType optionsByType) {
        Docker environment = (Docker)optionsByType.get(Docker.class, new Object[0]);
        Arguments arguments = Arguments.of(environment.getArguments()).with(this.commandArguments);
        optionsByType.add((Option)Executable.named((String)environment.getDockerExecutable()));
        environment.getEnvironmentVariables().forEach(arg_0 -> ((OptionsByType)optionsByType).add(arg_0));
        optionsByType.add((Option)arguments);
        Timeout timeout = this.getTimeout();
        if (timeout != null) {
            optionsByType.addIfAbsent((Option)timeout);
        }
    }

    public void onLaunched(Platform platform, Application application, OptionsByType optionsByType) {
    }

    public abstract C withCommandArguments(Argument ... var1);

    public abstract C withoutCommandArguments(Argument ... var1);

    public Arguments getCommandArguments() {
        return this.commandArguments;
    }

    public C timeoutAfter(long duration, TimeUnit units) {
        return this.timeoutAfter(Timeout.after((long)duration, (TimeUnit)units));
    }

    public C timeoutAfter(Timeout timeout) {
        this.timeout = Objects.requireNonNull(timeout, "The timeout cannot be null");
        return (C)this;
    }

    public Timeout getTimeout() {
        return this.timeout;
    }
}

