/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.docker.machine;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.docker.Docker;
import com.oracle.bedrock.runtime.docker.DockerPlatform;
import com.oracle.bedrock.runtime.docker.machine.DockerMachine;
import com.oracle.bedrock.runtime.docker.machine.MachineCloseBehaviour;
import com.oracle.bedrock.runtime.remote.Authentication;
import com.oracle.bedrock.runtime.remote.Password;
import com.oracle.bedrock.runtime.remote.RemotePlatform;
import com.oracle.bedrock.runtime.remote.options.StrictHostChecking;
import java.io.Closeable;
import java.net.InetAddress;

public class DockerMachinePlatform
extends DockerPlatform
implements Closeable {
    private final DockerMachine machine;

    public DockerMachinePlatform(DockerMachine machine, String name, Option ... options) {
        super(name, machine.getClientPlatform(), Docker.machine(name, machine, options), options);
        this.machine = machine;
    }

    public DockerMachine getDockerMachine() {
        return this.machine;
    }

    public RemotePlatform getRemotePlatform() {
        return this.getRemotePlatform(new Option[0]);
    }

    public RemotePlatform getRemotePlatform(Option ... options) {
        String name = this.getName();
        InetAddress address = this.machine.getAddress(name);
        OptionsByType platformOptions = OptionsByType.of((OptionsByType)this.getOptions()).add((Option)StrictHostChecking.disabled()).addAll(options);
        return new RemotePlatform(name, address, "docker", (Authentication)new Password("tcuser"), platformOptions.asArray());
    }

    @Override
    public void close() {
        this.close(new Option[0]);
    }

    public void close(Option ... options) {
        OptionsByType closeOptions = OptionsByType.of((OptionsByType)this.getOptions()).addAll(options);
        MachineCloseBehaviour behaviour = (MachineCloseBehaviour)closeOptions.get(MachineCloseBehaviour.class, new Object[0]);
        behaviour.accept(this);
    }

    public String status() {
        return this.machine.status(this.getName());
    }
}

